/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.github.zathrus_writer.commandsex.CommandsEX;
import com.github.zathrus_writer.commandsex.api.economy.Economy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_CommandsEX
extends AbstractEconomy {
    private final Logger log;
    private final String name = "CommandsEX Economy";
    private Plugin plugin = null;
    private CommandsEX economy = null;

    public Economy_CommandsEX(Plugin plugin) {
        Plugin commandsex;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (commandsex = plugin.getServer().getPluginManager().getPlugin("CommandsEX")) != null && commandsex.isEnabled()) {
            this.economy = (CommandsEX)commandsex;
            this.log.info(String.format("[Economy] %s hooked.", "CommandsEX Economy"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return Economy.isEnabled();
    }

    @Override
    public String getName() {
        return "CommandsEX Economy";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return 2;
    }

    @Override
    public String format(double amount) {
        return Economy.getCurrencySymbol() + amount;
    }

    @Override
    public String currencyNamePlural() {
        return Economy.getCurrencyPlural();
    }

    @Override
    public String currencyNameSingular() {
        return Economy.getCurrencySingular();
    }

    @Override
    public boolean hasAccount(String playerName) {
        return Economy.hasAccount((String)playerName);
    }

    @Override
    public double getBalance(String playerName) {
        return Economy.getBalance((String)playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return Economy.has((String)playerName, (double)amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String message;
        EconomyResponse.ResponseType rt;
        if (Economy.has((String)playerName, (double)amount)) {
            Economy.withdraw((String)playerName, (double)amount);
            rt = EconomyResponse.ResponseType.SUCCESS;
            message = null;
        } else {
            rt = EconomyResponse.ResponseType.FAILURE;
            message = "Not enough money";
        }
        return new EconomyResponse(amount, Economy.getBalance((String)playerName), rt, message);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        Economy.deposit((String)playerName, (double)amount);
        return new EconomyResponse(amount, Economy.getBalance((String)playerName), EconomyResponse.ResponseType.SUCCESS, "Successfully deposited");
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CommandsEX Economy does not support bank accounts");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (Economy.hasAccount((String)playerName)) {
            return false;
        }
        Economy.createAccount((String)playerName);
        return true;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_CommandsEX economy = null;

        public EconomyServerListener(Economy_CommandsEX economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin cex;
            if (this.economy.economy == null && (cex = event.getPlugin()).getDescription().getName().equals("CommandsEX")) {
                this.economy.economy = (CommandsEX)cex;
                Economy_CommandsEX.this.log.info(String.format("[Economy] %s hooked.", "CommandsEX Economy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("CommandsEX")) {
                this.economy.economy = null;
                Economy_CommandsEX.this.log.info(String.format("[Economy] %s unhooked.", "CommandsEX Economy"));
            }
        }
    }
}

