/*
 * Decompiled with CFR 0.152.
 */
package org.shininet.bukkit.playerheads;

import com.github.crashdemons.playerheads.SkullConverter;
import com.github.crashdemons.playerheads.SkullManager;
import com.github.crashdemons.playerheads.TexturedSkullType;
import com.github.crashdemons.playerheads.antispam.InteractSpamPreventer;
import com.github.crashdemons.playerheads.antispam.PlayerDeathSpamPreventer;
import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.CompatiblePlugins;
import com.github.crashdemons.playerheads.compatibility.plugins.SimulatedBlockBreakEvent;
import com.github.crashdemons.playerheads.compatibility.plugins.heads.HeadModificationHandling;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;
import org.shininet.bukkit.playerheads.BlockDropResult;
import org.shininet.bukkit.playerheads.Formatter;
import org.shininet.bukkit.playerheads.Lang;
import org.shininet.bukkit.playerheads.PlayerHeads;
import org.shininet.bukkit.playerheads.events.BlockDropHeadEvent;
import org.shininet.bukkit.playerheads.events.HeadRollEvent;
import org.shininet.bukkit.playerheads.events.MobDropHeadEvent;
import org.shininet.bukkit.playerheads.events.PlayerDropHeadEvent;

class PlayerHeadsListener
implements Listener {
    private final Random prng = new Random();
    private final PlayerHeads plugin;
    private volatile InteractSpamPreventer clickSpamPreventer;
    private volatile PlayerDeathSpamPreventer deathSpamPreventer;
    private static final long TICKS_PER_SECOND = 20L;
    private static final long MS_PER_TICK = 50L;
    private final Predicate<ItemStack> isVanillaHead = new Predicate<ItemStack>(){

        @Override
        public boolean test(ItemStack itemStack) {
            return Compatibility.getProvider().isHead(itemStack);
        }
    };

    public void registerAll() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void unregisterAll() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
        PlayerJoinEvent.getHandlerList().unregister((Listener)this);
        BlockBreakEvent.getHandlerList().unregister((Listener)this);
    }

    protected PlayerHeadsListener(PlayerHeads plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        FileConfiguration cfg = this.plugin.configFile;
        this.clickSpamPreventer = new InteractSpamPreventer(cfg.getInt("clickspamcount"), cfg.getLong("clickspamthreshold"));
        this.deathSpamPreventer = new PlayerDeathSpamPreventer(cfg.getInt("deathspamcount"), cfg.getLong("deathspamthreshold"));
    }

    private Entity getEntityOwningEntity(EntityDamageByEntityEvent event) {
        AnimalTamer tamer;
        Tameable animal;
        Entity entity = event.getDamager();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            ProjectileSource shooter = projectile.getShooter();
            if (shooter instanceof Entity) {
                entity = (Entity)shooter;
            }
        } else if (entity instanceof Tameable && this.plugin.configFile.getBoolean("considertameowner") && (animal = (Tameable)entity).isTamed() && (tamer = animal.getOwner()) instanceof Entity) {
            entity = (Entity)tamer;
        }
        return entity;
    }

    private LivingEntity getKillerEntity(EntityDeathEvent event) {
        Entity killerEntity;
        EntityDamageEvent dmgEvent;
        LivingEntity victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer == null && this.plugin.configFile.getBoolean("considermobkillers") && (dmgEvent = event.getEntity().getLastDamageCause()) instanceof EntityDamageByEntityEvent && (killerEntity = this.getEntityOwningEntity((EntityDamageByEntityEvent)dmgEvent)) instanceof LivingEntity) {
            killer = (LivingEntity)killerEntity;
        }
        return killer;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        TexturedSkullType skullType;
        LivingEntity victim = event.getEntity();
        LivingEntity killer = this.getKillerEntity(event);
        double lootingrate = 1.0;
        String chargedcreeperBehavior = "ignore";
        Double chargedcreeperModifier = 1.0;
        if (killer != null) {
            ItemStack weapon;
            if (killer instanceof Creeper && !(victim instanceof Player) && ((Creeper)killer).isPowered()) {
                chargedcreeperBehavior = this.plugin.configFile.getString("chargedcreeperbehavior");
                chargedcreeperModifier = this.plugin.configFile.getDouble("chargedcreepermodifier");
                if (chargedcreeperBehavior.equals("block") || chargedcreeperBehavior.equals("replace")) {
                    event.getDrops().removeIf(this.isVanillaHead);
                }
                if (chargedcreeperBehavior.equals("block") || chargedcreeperBehavior.equals("vanilla")) {
                    return;
                }
            }
            if ((weapon = Compatibility.getProvider().getItemInMainHand(killer)) != null) {
                if (this.plugin.configFile.getBoolean("requireitem")) {
                    String weaponType = weapon.getType().name().toLowerCase();
                    if (!this.plugin.configFile.getStringList("requireditems").contains(weaponType)) {
                        return;
                    }
                }
                lootingrate = 1.0 + this.plugin.configFile.getDouble("lootingrate") * (double)weapon.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS);
            }
        }
        if ((skullType = SkullConverter.skullTypeFromEntity((Entity)victim)) == null) {
            return;
        }
        String mobDropConfig = skullType.getConfigName();
        Double droprate = this.plugin.configFile.getDouble(mobDropConfig);
        if (droprate < 0.0) {
            return;
        }
        switch (skullType) {
            case PLAYER: {
                if (this.plugin.configFile.getBoolean("nerfdeathspam") && this.deathSpamPreventer.recordEvent(event).isSpam()) {
                    return;
                }
                this.PlayerDeathHelper(event, skullType, droprate, lootingrate, chargedcreeperModifier);
                break;
            }
            case WITHER_SKELETON: {
                String witherskeletonbehavior = this.plugin.getConfig().getString("witherskeletonbehavior");
                if (witherskeletonbehavior.equals("block") || witherskeletonbehavior.equals("replace")) {
                    event.getDrops().removeIf(this.isVanillaHead);
                }
                if (witherskeletonbehavior.equals("block") || witherskeletonbehavior.equals("vanilla")) {
                    return;
                }
                this.MobDeathHelper(event, skullType, droprate, lootingrate, 1.0, chargedcreeperModifier);
                break;
            }
            case SLIME: 
            case MAGMA_CUBE: {
                Double slimemodifier = 1.0;
                LivingEntity entity = event.getEntity();
                if (entity instanceof Slime) {
                    int slimeSize = ((Slime)entity).getSize();
                    slimemodifier = this.plugin.configFile.getDouble("slimemodifier." + slimeSize);
                }
                this.MobDeathHelper(event, skullType, droprate, lootingrate, slimemodifier, chargedcreeperModifier);
                break;
            }
            default: {
                this.MobDeathHelper(event, skullType, droprate, lootingrate, 1.0, chargedcreeperModifier);
            }
        }
    }

    private void PlayerDeathHelper(EntityDeathEvent event, TexturedSkullType type, Double droprateOriginal, Double lootingModifier, Double chargedcreeperModifier) {
        Double dropchanceRand;
        Double droprate = droprateOriginal * lootingModifier * chargedcreeperModifier;
        Double dropchance = dropchanceRand = Double.valueOf(this.prng.nextDouble());
        Player player = (Player)event.getEntity();
        Player killer = event.getEntity().getKiller();
        boolean killerAlwaysBeheads = false;
        if (!player.hasPermission("playerheads.canlosehead")) {
            return;
        }
        if (killer != null) {
            if (!killer.hasPermission("playerheads.canbehead")) {
                return;
            }
            killerAlwaysBeheads = killer.hasPermission("playerheads.alwaysbehead");
            if (killerAlwaysBeheads) {
                dropchance = 0.0;
            }
        }
        if ((killer == player || killer == null) && this.plugin.configFile.getBoolean("pkonly")) {
            return;
        }
        boolean headDropSuccess = dropchance < droprate;
        HeadRollEvent rollEvent = new HeadRollEvent((Entity)killer, (Entity)player, killerAlwaysBeheads, lootingModifier, 1.0, chargedcreeperModifier, dropchanceRand, dropchance, droprateOriginal, droprate, headDropSuccess);
        this.plugin.getServer().getPluginManager().callEvent((Event)rollEvent);
        if (!rollEvent.succeeded()) {
            return;
        }
        ItemStack drop = this.plugin.api.getHeadDrop((Entity)player);
        PlayerDropHeadEvent dropHeadEvent = new PlayerDropHeadEvent(player, drop);
        this.plugin.getServer().getPluginManager().callEvent((Event)dropHeadEvent);
        if (dropHeadEvent.isCancelled()) {
            return;
        }
        drop = dropHeadEvent.getDrop();
        if (drop != null) {
            if (this.plugin.configFile.getBoolean("antideathchest") || Compatibility.getProvider().getKeepInventory(player.getWorld())) {
                Location location = player.getLocation();
                location.getWorld().dropItemNaturally(location, drop);
            } else {
                event.getDrops().add(drop);
            }
        }
        if (this.plugin.configFile.getBoolean("broadcast")) {
            String message = killer == null ? Formatter.format(Lang.BEHEAD_GENERIC, player.getDisplayName() + ChatColor.RESET) : (killer == player ? Formatter.format(Lang.BEHEAD_SELF, player.getDisplayName() + ChatColor.RESET) : Formatter.format(Lang.BEHEAD_OTHER, player.getDisplayName() + ChatColor.RESET, killer.getDisplayName() + ChatColor.RESET));
            int broadcastRange = this.plugin.configFile.getInt("broadcastrange");
            if (broadcastRange > 0) {
                broadcastRange *= broadcastRange;
                Location location = player.getLocation();
                List players = player.getWorld().getPlayers();
                for (Player loopPlayer : players) {
                    try {
                        if (!(location.distanceSquared(loopPlayer.getLocation()) <= (double)broadcastRange)) continue;
                        loopPlayer.sendMessage(message);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                this.plugin.getServer().broadcastMessage(message);
            }
        }
    }

    private void MobDeathHelper(EntityDeathEvent event, TexturedSkullType type, Double droprateOriginal, Double lootingModifier, Double slimeModifier, Double chargedcreeperModifier) {
        Location location;
        Double dropchanceRand;
        Double droprate = droprateOriginal * lootingModifier * slimeModifier * chargedcreeperModifier;
        Double dropchance = dropchanceRand = Double.valueOf(this.prng.nextDouble());
        LivingEntity entity = event.getEntity();
        Player killer = event.getEntity().getKiller();
        boolean killerAlwaysBeheads = false;
        if (killer != null) {
            if (!killer.hasPermission("playerheads.canbeheadmob")) {
                return;
            }
            killerAlwaysBeheads = killer.hasPermission("playerheads.alwaysbeheadmob");
            if (killerAlwaysBeheads) {
                dropchance = 0.0;
            }
        } else if (this.plugin.configFile.getBoolean("mobpkonly")) {
            return;
        }
        boolean headDropSuccess = dropchance < droprate;
        HeadRollEvent rollEvent = new HeadRollEvent((Entity)killer, (Entity)event.getEntity(), killerAlwaysBeheads, lootingModifier, slimeModifier, chargedcreeperModifier, dropchanceRand, dropchance, droprateOriginal, droprate, headDropSuccess);
        this.plugin.getServer().getPluginManager().callEvent((Event)rollEvent);
        if (!rollEvent.succeeded()) {
            return;
        }
        ItemStack drop = this.plugin.api.getHeadDrop((Entity)entity);
        MobDropHeadEvent dropHeadEvent = new MobDropHeadEvent(event.getEntity(), drop);
        this.plugin.getServer().getPluginManager().callEvent((Event)dropHeadEvent);
        if (dropHeadEvent.isCancelled()) {
            return;
        }
        drop = dropHeadEvent.getDrop();
        final ItemStack finalDrop = drop;
        if (finalDrop != null) {
            if (type == TexturedSkullType.WITHER && this.plugin.configFile.getBoolean("delaywitherdrop")) {
                int delay = this.plugin.configFile.getInt("delaywitherdropms");
                long ticks = (long)delay / 50L;
                location = event.getEntity().getLocation();
                this.plugin.scheduleSync(new Runnable(){

                    @Override
                    public void run() {
                        location.getWorld().dropItemNaturally(location, finalDrop);
                    }
                }, ticks);
            } else if (this.plugin.configFile.getBoolean("antideathchest")) {
                Location location2 = event.getEntity().getLocation();
                location2.getWorld().dropItemNaturally(location2, finalDrop);
            } else {
                event.getDrops().add(finalDrop);
            }
        }
        if (this.plugin.configFile.getBoolean("broadcastmob") && killer != null) {
            String entityName = entity.getCustomName();
            if (entityName == null) {
                entityName = entity.getName();
            }
            String message = Formatter.format(Lang.BEHEAD_OTHER, entityName + ChatColor.RESET, killer.getDisplayName() + ChatColor.RESET);
            int broadcastRange = this.plugin.configFile.getInt("broadcastmobrange");
            if (broadcastRange > 0) {
                broadcastRange *= broadcastRange;
                location = entity.getLocation();
                List players = entity.getWorld().getPlayers();
                for (Player loopPlayer : players) {
                    try {
                        if (!(location.distanceSquared(loopPlayer.getLocation()) <= (double)broadcastRange)) continue;
                        loopPlayer.sendMessage(message);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                this.plugin.getServer().broadcastMessage(message);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (block != null) {
            BlockState state = block.getState();
            if (CompatiblePlugins.heads.getExternalHeadHandling(state) == HeadModificationHandling.NO_INTERACTION) {
                return;
            }
            TexturedSkullType skullType = SkullConverter.skullTypeFromBlockState(state);
            if (skullType == null) {
                return;
            }
            if (this.clickSpamPreventer.recordEvent(event).isSpam()) {
                return;
            }
            if (player.hasPermission("playerheads.clickinfo")) {
                switch (skullType) {
                    case PLAYER: {
                        Skull skullState = (Skull)block.getState();
                        if (skullState.hasOwner()) {
                            String owner = Compatibility.getProvider().getOwner(skullState);
                            if (owner == null) {
                                return;
                            }
                            Formatter.formatMsg((CommandSender)player, Lang.CLICKINFO, owner);
                            break;
                        }
                        Formatter.formatMsg((CommandSender)player, Lang.CLICKINFO2, Lang.HEAD);
                        break;
                    }
                    default: {
                        Formatter.formatMsg((CommandSender)player, Lang.CLICKINFO2, skullType.getDisplayName());
                    }
                }
            }
            SkullManager.updatePlayerSkullState(state);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemSpawnEvent(ItemSpawnEvent event) {
        ItemStack stack = event.getEntity().getItemStack();
        if (CompatiblePlugins.heads.getExternalHeadHandling(stack) == HeadModificationHandling.NO_INTERACTION) {
            return;
        }
        boolean fixDroppedHeads = this.plugin.configFile.getBoolean("fixdroppedheads");
        if (!fixDroppedHeads) {
            return;
        }
        TexturedSkullType skullType = SkullConverter.skullTypeFromItemStack(stack);
        if (skullType == null) {
            return;
        }
        this.onHeadItemSpawn(event, stack, skullType);
    }

    private void onHeadItemSpawn(ItemSpawnEvent event, ItemStack stack, TexturedSkullType skullType) {
        boolean restoreprofile = this.plugin.configFile.getBoolean("restoreprofile");
        boolean isSkinnable = Compatibility.getProvider().isPlayerhead(stack);
        Optional<Object> savedProfile = Optional.empty();
        if (isSkinnable && restoreprofile) {
            SkullMeta skull = (SkullMeta)stack.getItemMeta();
            savedProfile = Compatibility.getProvider().getOptionalProfile((ItemMeta)skull);
        }
        ItemStack newstack = null;
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        switch (skullType) {
            case PLAYER: {
                SkullMeta skull = (SkullMeta)stack.getItemMeta();
                String owner = Compatibility.getProvider().getOwner(skull);
                if (owner == null) {
                    return;
                }
                newstack = SkullManager.PlayerSkull(owner, stack.getAmount(), addLore, savedProfile);
                break;
            }
            default: {
                newstack = this.createConvertedMobhead(skullType, isSkinnable, addLore, stack.getAmount(), true, savedProfile);
            }
        }
        if (newstack == null) {
            return;
        }
        event.getEntity().setItemStack(newstack);
    }

    private static boolean canConversionHappen(boolean dropVanillaHeads, boolean isSourceSkinnable) {
        return isSourceSkinnable && dropVanillaHeads || !isSourceSkinnable && !dropVanillaHeads;
    }

    @Nullable
    private ItemStack createConvertedMobhead(TexturedSkullType skullType, boolean isSourceSkinnable, boolean addLore, int quantity, boolean avoidVanillaReplacement, Optional<Object> oldProfile) {
        boolean dropvanillaheads = this.plugin.configFile.getBoolean("dropvanillaheads");
        boolean convertvanillaheads = this.plugin.configFile.getBoolean("convertvanillaheads");
        boolean conversionCanHappen = PlayerHeadsListener.canConversionHappen(dropvanillaheads, isSourceSkinnable);
        if (conversionCanHappen && !convertvanillaheads) {
            boolean bl = dropvanillaheads = !dropvanillaheads;
        }
        if (avoidVanillaReplacement && !isSourceSkinnable && dropvanillaheads) {
            return null;
        }
        return SkullManager.MobSkull(skullType, quantity, dropvanillaheads, addLore, oldProfile);
    }

    private BlockDropResult blockDrop(BlockEvent event, Block block, BlockState state, Optional<Object> oldProfile) {
        if (CompatiblePlugins.heads.getExternalHeadHandling(state) == HeadModificationHandling.NO_INTERACTION) {
            return BlockDropResult.FAILED_BLOCKED_HEAD;
        }
        TexturedSkullType skullType = SkullConverter.skullTypeFromBlockState(state);
        Location location = block.getLocation();
        ItemStack item = null;
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        switch (skullType) {
            case PLAYER: {
                Skull skull = (Skull)block.getState();
                String owner = Compatibility.getProvider().getOwner(skull);
                if (owner == null) {
                    return BlockDropResult.FAILED_CUSTOM_HEAD;
                }
                item = SkullManager.PlayerSkull(owner, addLore);
                break;
            }
            default: {
                boolean blockIsSkinnable = Compatibility.getProvider().isPlayerhead(block.getState());
                item = this.createConvertedMobhead(skullType, blockIsSkinnable, addLore, 1, true, oldProfile);
                if (item != null) break;
                return BlockDropResult.FAILED_DEFERRED_TO_VANILLA;
            }
        }
        block.setType(Material.AIR);
        BlockDropHeadEvent eventDropHead = new BlockDropHeadEvent(block, item);
        this.plugin.getServer().getPluginManager().callEvent((Event)eventDropHead);
        if (eventDropHead.isCancelled()) {
            return BlockDropResult.FAILED_EVENT_CANCELLED;
        }
        item = eventDropHead.getDrop();
        if (item != null) {
            location.getWorld().dropItemNaturally(location, item);
        }
        return BlockDropResult.SUCCESS;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        BlockState state;
        TexturedSkullType skullType;
        if (event instanceof SimulatedBlockBreakEvent) {
            return;
        }
        boolean fixbrokenheads = this.plugin.configFile.getBoolean("fixbrokenheads");
        if (!fixbrokenheads) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (CompatiblePlugins.heads.getExternalHeadHandling(block.getState()) == HeadModificationHandling.NO_INTERACTION) {
            return;
        }
        if (player.getGameMode() != GameMode.CREATIVE && (skullType = SkullConverter.skullTypeFromBlockState(state = block.getState())) != null) {
            boolean canBreak = true;
            boolean pretestblockbreak = this.plugin.getConfig().getBoolean("pretestblockbreak");
            if (pretestblockbreak && CompatiblePlugins.isReady()) {
                canBreak = CompatiblePlugins.testBlockBreak(block, player);
            }
            if (!canBreak) {
                event.setCancelled(true);
                return;
            }
            this.onHeadBreak(event, block, state, skullType);
        }
    }

    private void onHeadBreak(BlockBreakEvent event, Block block, BlockState state, TexturedSkullType skullType) {
        boolean restoreprofile = this.plugin.configFile.getBoolean("restoreprofile");
        boolean isSkinnable = Compatibility.getProvider().isPlayerhead(state);
        Optional<Object> savedProfile = Optional.empty();
        if (isSkinnable && restoreprofile) {
            Skull skull = (Skull)state;
            savedProfile = Compatibility.getProvider().getOptionalProfile(skull);
        }
        event.setCancelled(true);
        BlockDropResult result = this.blockDrop((BlockEvent)event, block, state, savedProfile);
        if (result == BlockDropResult.FAILED_CUSTOM_HEAD || result == BlockDropResult.FAILED_BLOCKED_HEAD || result == BlockDropResult.FAILED_DEFERRED_TO_VANILLA) {
            event.setCancelled(false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("playerheads.update") && this.plugin.getUpdateReady()) {
            Formatter.formatMsg((CommandSender)player, Lang.UPDATE1, this.plugin.getUpdateName());
            Formatter.formatMsg((CommandSender)player, Lang.UPDATE3, "http://curse.com/bukkit-plugins/minecraft/player-heads");
        }
    }
}

