/*
 * Decompiled with CFR 0.152.
 */
package org.shininet.bukkit.playerheads;

import com.github.crashdemons.playerheads.SkullConverter;
import com.github.crashdemons.playerheads.SkullManager;
import com.github.crashdemons.playerheads.TexturedSkullType;
import com.github.crashdemons.playerheads.compatibility.Compatibility;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.shininet.bukkit.playerheads.Config;
import org.shininet.bukkit.playerheads.Formatter;
import org.shininet.bukkit.playerheads.InventoryManager;
import org.shininet.bukkit.playerheads.Lang;
import org.shininet.bukkit.playerheads.PlayerHeads;

class PlayerHeadsCommandExecutor
implements CommandExecutor,
TabCompleter {
    private final PlayerHeads plugin;

    public PlayerHeadsCommandExecutor(PlayerHeads plugin) {
        this.plugin = plugin;
    }

    private void formatMsg(CommandSender sender, String commandscope, String message, String ... replacements) {
        Formatter.formatMsg(sender, Lang.BRACKET_LEFT + commandscope + Lang.BRACKET_RIGHT + Lang.SPACE + message, replacements);
    }

    private String getConfigDisplay(String key) {
        return key + Lang.COLON_SPACE + Config.getValueDisplayString(this.plugin.configFile, key);
    }

    private boolean onCommandConfigGet(CommandSender sender, Command cmd, String label, String[] args, String scope) {
        if (!sender.hasPermission("playerheads.config.get")) {
            this.formatMsg(sender, scope, Lang.ERROR_PERMISSION, new String[0]);
            return true;
        }
        if (args.length == 3) {
            String key = args[2].toLowerCase();
            this.formatMsg(sender, scope, this.getConfigDisplay(key), new String[0]);
        } else {
            this.formatMsg(sender, scope, Lang.SYNTAX + Lang.COLON_SPACE + scope + Lang.SPACE + Lang.OPT_VARIABLE_REQUIRED, new String[0]);
            this.formatMsg(sender, scope, Lang.CONFIG_VARIABLES + Lang.COLON_SPACE + Config.configKeysString, new String[0]);
        }
        return true;
    }

    private boolean onCommandConfigSet(CommandSender sender, Command cmd, String label, String[] args, String scope) {
        if (!sender.hasPermission("playerheads.config.set")) {
            this.formatMsg(sender, scope, Lang.ERROR_PERMISSION, new String[0]);
            return true;
        }
        if (args.length == 3) {
            String key = args[2].toLowerCase();
            this.plugin.configFile.set(key, null);
            this.plugin.saveConfig();
            this.formatMsg(sender, scope, this.getConfigDisplay(key), new String[0]);
            return true;
        }
        if (args.length == 4) {
            String key = args[2].toLowerCase();
            String value = args[3];
            try {
                Config.setValue(this.plugin.configFile, key, value);
            }
            catch (NumberFormatException e) {
                this.formatMsg(sender, scope, Lang.ERROR_NUMBERCONVERT, value);
            }
            catch (IllegalStateException e) {
                this.plugin.logger.warning(Formatter.format(Lang.ERROR_CONFIGTYPE, Config.configKeys.get(key).toString()));
            }
            this.plugin.saveConfig();
            this.formatMsg(sender, scope, this.getConfigDisplay(key), new String[0]);
            return true;
        }
        this.formatMsg(sender, scope, Lang.SYNTAX + Lang.COLON_SPACE + scope + Lang.SPACE + Lang.OPT_VARIABLE_REQUIRED + Lang.SPACE + Lang.OPT_VALUE_OPTIONAL, new String[0]);
        this.formatMsg(sender, scope, Lang.CONFIG_VARIABLES + Lang.COLON_SPACE + Config.configKeysString, new String[0]);
        return true;
    }

    private boolean onCommandConfigReload(CommandSender sender, Command cmd, String label, String[] args, String scope) {
        if (!sender.hasPermission("playerheads.config.set")) {
            this.formatMsg(sender, scope, Lang.ERROR_PERMISSION, new String[0]);
            return true;
        }
        this.plugin.reloadConfig();
        this.plugin.configFile = this.plugin.getConfig();
        Lang.reload();
        this.plugin.onConfigReloaded();
        this.formatMsg(sender, scope, Lang.CONFIG_RELOADED, new String[0]);
        return true;
    }

    private boolean onCommandConfig(CommandSender sender, Command cmd, String label, String[] args, String scope) {
        if (args.length == 1) {
            this.formatMsg(sender, scope, Lang.SUBCOMMANDS + Lang.COLON_SPACE + Lang.CMD_GET + Lang.COMMA_SPACE + Lang.CMD_SET + Lang.COMMA_SPACE + Lang.CMD_RELOAD, new String[0]);
            return true;
        }
        if (args[1].equalsIgnoreCase(Formatter.formatStrip(Lang.CMD_GET, new String[0]))) {
            return this.onCommandConfigGet(sender, cmd, label, args, scope + Lang.COLON + Lang.CMD_GET);
        }
        if (args[1].equalsIgnoreCase(Formatter.formatStrip(Lang.CMD_SET, new String[0]))) {
            return this.onCommandConfigSet(sender, cmd, label, args, scope + Lang.COLON + Lang.CMD_SET);
        }
        if (args[1].equalsIgnoreCase(Formatter.formatStrip(Lang.CMD_RELOAD, new String[0]))) {
            return this.onCommandConfigReload(sender, cmd, label, args, scope + Lang.COLON + Lang.CMD_RELOAD);
        }
        scope = scope + Lang.COLON + Lang.CMD_UNKNOWN;
        this.formatMsg(sender, scope, Lang.ERROR_INVALID_SUBCOMMAND, new String[0]);
        return true;
    }

    private boolean onCommandSpawn(CommandSender sender, Command cmd, String label, String[] args, String scope) {
        boolean addLore;
        boolean haspermission;
        String skullOwner;
        Player reciever = null;
        int quantity = 1;
        boolean isConsoleSender = !(sender instanceof Player);
        boolean usevanillaskull = this.plugin.configFile.getBoolean("dropvanillaheads");
        if (isConsoleSender) {
            if (args.length != 3 && args.length != 4) {
                this.formatMsg(sender, scope, Lang.SYNTAX + Lang.COLON_SPACE + scope + Lang.SPACE + Lang.OPT_HEADNAME_REQUIRED + Lang.SPACE + Lang.OPT_RECEIVER_REQUIRED + Lang.SPACE + Lang.OPT_AMOUNT_OPTIONAL, new String[0]);
                return true;
            }
        } else {
            reciever = (Player)sender;
        }
        if (args.length == 1 || args.length == 2 && sender.getName().equalsIgnoreCase(args[1])) {
            skullOwner = sender.getName();
            haspermission = sender.hasPermission("playerheads.spawn.own");
        } else if (args.length == 2) {
            skullOwner = args[1];
            haspermission = sender.hasPermission("playerheads.spawn");
        } else if (args.length == 3 || args.length == 4) {
            if (args.length == 4) {
                try {
                    quantity = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((reciever = this.plugin.getServer().getPlayer(args[2])) == null) {
                this.formatMsg(sender, scope, Lang.ERROR_NOT_ONLINE, args[2]);
                return true;
            }
            skullOwner = args[1];
            haspermission = reciever.equals(sender) ? sender.hasPermission("playerheads.spawn") : sender.hasPermission("playerheads.spawn.forother");
        } else {
            this.formatMsg(sender, scope, Lang.SYNTAX + Lang.COLON_SPACE + scope + Lang.SPACE + Lang.OPT_HEADNAME_OPTIONAL + Lang.SPACE + Lang.OPT_RECEIVER_OPTIONAL + Lang.SPACE + Lang.OPT_AMOUNT_OPTIONAL, new String[0]);
            return true;
        }
        if (!haspermission) {
            this.formatMsg(sender, scope, Lang.ERROR_PERMISSION, new String[0]);
            return true;
        }
        if (this.plugin.configFile.getBoolean("fixcase")) {
            skullOwner = PlayerHeadsCommandExecutor.fixcase(skullOwner);
        }
        if (InventoryManager.addHead(reciever, skullOwner, quantity, usevanillaskull, addLore = this.plugin.configFile.getBoolean("addlore"))) {
            TexturedSkullType type = TexturedSkullType.getBySpawnName(skullOwner);
            String headName = type == null ? TexturedSkullType.getDisplayName(skullOwner) : type.getDisplayName();
            String forWhom = reciever.getName();
            this.formatMsg(sender, scope, Lang.SPAWNED_HEAD2, headName, forWhom, "" + quantity);
        } else {
            this.formatMsg(sender, scope, Lang.ERROR_INV_FULL, new String[0]);
        }
        return true;
    }

    private boolean onCommandRename(CommandSender sender, Command cmd, String label, String[] args, String scope) {
        boolean usevanillaskull = this.plugin.configFile.getBoolean("dropvanillaheads");
        if (!(sender instanceof Player)) {
            this.formatMsg(sender, scope, Lang.ERROR_CONSOLE_SPAWN, new String[0]);
            return true;
        }
        if (!(sender.hasPermission("playerheads.rename") || sender.hasPermission("playerheads.rename.mob") || sender.hasPermission("playerheads.rename.player"))) {
            this.formatMsg(sender, scope, Lang.ERROR_PERMISSION, new String[0]);
            return true;
        }
        if (args.length != 1 && args.length != 2) {
            this.formatMsg(sender, scope, Lang.SYNTAX + Lang.COLON_SPACE + scope + Lang.SPACE + Lang.OPT_HEADNAME_OPTIONAL, new String[0]);
            return true;
        }
        ItemStack skullInput = Compatibility.getProvider().getItemInMainHand((Player)sender);
        TexturedSkullType inputSkullType = SkullConverter.skullTypeFromItemStack(skullInput);
        if (inputSkullType == null) {
            this.formatMsg(sender, scope, Lang.ERROR_NOT_A_HEAD, new String[0]);
            return true;
        }
        String spawnName = "";
        if (args.length >= 2) {
            spawnName = args[1];
            if (this.plugin.configFile.getBoolean("fixcase")) {
                spawnName = PlayerHeadsCommandExecutor.fixcase(spawnName);
            }
        }
        TexturedSkullType outputSkullType = TexturedSkullType.getBySpawnName(spawnName);
        boolean fromPlayerhead = inputSkullType == TexturedSkullType.PLAYER;
        boolean toPlayerhead = outputSkullType == TexturedSkullType.PLAYER || outputSkullType == null;
        boolean mobRename = !fromPlayerhead && !toPlayerhead;
        boolean playerRename = fromPlayerhead && toPlayerhead;
        boolean hasPermission = false;
        if (mobRename) {
            hasPermission = sender.hasPermission("playerheads.rename.mob");
            scope = scope + Lang.COLON + Lang.CMD_RENAME_SCOPE_MOB;
        } else if (playerRename) {
            hasPermission = sender.hasPermission("playerheads.rename.player");
            scope = scope + Lang.COLON + Lang.CMD_RENAME_SCOPE_PLAYER;
        } else {
            hasPermission = sender.hasPermission("playerheads.rename");
            scope = scope + Lang.COLON + Lang.CMD_RENAME_SCOPE_ALL;
        }
        if (!hasPermission) {
            this.formatMsg(sender, scope, Lang.ERROR_PERMISSION, new String[0]);
            return true;
        }
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        ItemStack skullOutput = SkullManager.spawnSkull(spawnName, usevanillaskull, addLore);
        skullOutput.setAmount(skullInput.getAmount());
        Compatibility.getProvider().setItemInMainHand((Player)sender, skullOutput);
        this.formatMsg(sender, scope, Lang.RENAMED_HEAD, new String[0]);
        return true;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("PlayerHeads")) {
            return false;
        }
        String scope = label;
        if (args.length == 0) {
            this.formatMsg(sender, scope, Lang.SUBCOMMANDS + Lang.COLON_SPACE + Lang.CMD_CONFIG + Lang.COMMA_SPACE + Lang.CMD_SPAWN + Lang.COMMA_SPACE + Lang.CMD_RENAME, new String[0]);
            return true;
        }
        if (args[0].equalsIgnoreCase(Formatter.formatStrip(Lang.CMD_CONFIG, new String[0]))) {
            return this.onCommandConfig(sender, cmd, label, args, scope + Lang.COLON + Lang.CMD_CONFIG);
        }
        if (args[0].equalsIgnoreCase(Formatter.formatStrip(Lang.CMD_SPAWN, new String[0]))) {
            return this.onCommandSpawn(sender, cmd, label, args, scope + Lang.COLON + Lang.CMD_SPAWN);
        }
        if (args[0].equalsIgnoreCase(Formatter.formatStrip(Lang.CMD_RENAME, new String[0]))) {
            return this.onCommandRename(sender, cmd, label, args, scope + Lang.COLON + Lang.CMD_RENAME);
        }
        scope = scope + Lang.COLON + Lang.CMD_UNKNOWN;
        this.formatMsg(sender, scope, Lang.ERROR_INVALID_SUBCOMMAND, new String[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("PlayerHeads")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].toLowerCase();
        }
        String cmd_config = Formatter.formatStrip(Lang.CMD_CONFIG, new String[0]);
        String cmd_get = Formatter.formatStrip(Lang.CMD_GET, new String[0]);
        String cmd_reload = Formatter.formatStrip(Lang.CMD_RELOAD, new String[0]);
        String cmd_rename = Formatter.formatStrip(Lang.CMD_RENAME, new String[0]);
        String cmd_set = Formatter.formatStrip(Lang.CMD_SET, new String[0]);
        String cmd_spawn = Formatter.formatStrip(Lang.CMD_SPAWN, new String[0]);
        if (args.length == 1) {
            if (cmd_config.startsWith(args[0])) {
                completions.add(cmd_config);
            }
            if (cmd_spawn.startsWith(args[0])) {
                completions.add(cmd_spawn);
            }
            if (cmd_rename.startsWith(args[0])) {
                completions.add(cmd_rename);
            }
            return this.sort(completions);
        }
        if (args[0].equals(cmd_config)) {
            if (args.length == 2) {
                if (cmd_get.startsWith(args[1])) {
                    completions.add(cmd_get);
                }
                if (cmd_set.startsWith(args[1])) {
                    completions.add(cmd_set);
                }
                if (cmd_reload.startsWith(args[1])) {
                    completions.add(cmd_reload);
                }
                return this.sort(completions);
            }
            if ((args[1].equals(cmd_get) || args[1].equals(cmd_set)) && args.length == 3) {
                for (String keySet : Config.configKeys.keySet()) {
                    if (!keySet.startsWith(args[2])) continue;
                    completions.add(keySet);
                }
                return this.sort(completions);
            }
            return completions;
        }
        if (args[0].equals(cmd_spawn) ? args.length > 3 : args[0].equals(cmd_rename) && args.length > 2) {
            return completions;
        }
        return null;
    }

    private List<String> sort(List<String> completions) {
        completions.sort(String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    private static String fixcase(String inputName) {
        String inputNameLC = inputName.toLowerCase();
        Player player = Bukkit.getServer().getPlayerExact(inputNameLC);
        if (player != null) {
            return player.getName();
        }
        for (OfflinePlayer offPlayer : Bukkit.getServer().getOfflinePlayers()) {
            if (offPlayer.getName() == null || !offPlayer.getName().toLowerCase().equals(inputNameLC)) continue;
            return offPlayer.getName();
        }
        return inputName;
    }
}

