/*
 * Decompiled with CFR 0.152.
 */
package org.shininet.bukkit.playerheads;

import com.github.crashdemons.playerheads.api.ApiProvider;
import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.CompatiblePlugins;
import com.github.crashdemons.playerheads.compatibility.Version;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityUnavailableException;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityUnsupportedException;
import com.github.crashdemons.playerheads.compatibility.exceptions.UnknownVersionException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.shininet.bukkit.playerheads.Lang;
import org.shininet.bukkit.playerheads.PlayerHeadsCommandExecutor;
import org.shininet.bukkit.playerheads.PlayerHeadsListener;
import org.shininet.bukkit.playerheads.PlayerHeadsPlugin;

public final class PlayerHeads
extends JavaPlugin
implements Listener,
PlayerHeadsPlugin {
    public static PlayerHeads instance;
    private PlayerHeadsListener listener;
    public Logger logger;
    public FileConfiguration configFile;
    public final ApiProvider api;
    private static boolean updateReady;
    private static String updateName;
    private boolean compatibilityFailed = false;

    private void logCompatibilityIssue(String description, String reportcomment) {
        this.logger.severe(description);
        this.logger.severe("  " + Lang.COMPATIBILITY_VERSION_RAW + Lang.COLON_SPACE + Version.getRawServerVersion());
        this.logger.severe("  " + Lang.COMPATIBILITY_VERSION_DETECTED + Lang.COLON_SPACE + Version.getType() + " " + Version.getString());
        this.logger.severe(reportcomment);
        this.compatibilityFailed = true;
    }

    private void logCompatibilityBug(String description) {
        this.logCompatibilityIssue(description, Lang.COMPATIBILITY_REPORT_BUG);
    }

    private void logCompatibilityError(String description) {
        this.logCompatibilityIssue(description, Lang.COMPATIBILITY_REPORT_ERROR);
    }

    private void initializeCompatibility() {
        boolean isUsingRecommendedVersion = true;
        try {
            isUsingRecommendedVersion = Compatibility.init();
        }
        catch (UnknownVersionException e) {
            this.logCompatibilityBug(Lang.ERROR_COMPATIBILITY_UNKNOWN_VERSION);
            throw e;
        }
        catch (CompatibilityUnsupportedException e) {
            this.logCompatibilityError(Lang.ERROR_COMPATIBILITY_SERVER_VERSION);
            throw e;
        }
        catch (CompatibilityUnavailableException e) {
            this.logCompatibilityError(Lang.ERROR_COMPATIBILITY_NOT_FOUND);
            throw e;
        }
        if (!isUsingRecommendedVersion) {
            this.logger.warning(Lang.WARNING_COMPATIBILITY_DIFFERENT);
            this.logger.warning("  " + Lang.COMPATIBILITY_VERSION_DETECTED + Lang.COLON_SPACE + Version.getType() + " " + Version.getString());
            this.logger.warning("  " + Lang.COMPATIBILITY_VERSION_RECOMMENDED + Lang.COLON_SPACE + Compatibility.getRecommendedProviderType() + " " + Compatibility.getRecommendedProviderVersion() + " (or better)");
            this.logger.warning("  " + Lang.COMPATIBILITY_VERSION_CURRENT + Lang.COLON_SPACE + Compatibility.getProvider().getType() + " " + Compatibility.getProvider().getVersion());
        }
    }

    public void scheduleSync(Runnable task, long tick_delay) {
        int tasknum = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, task, tick_delay);
    }

    public PlayerHeads() {
        instance = this;
        this.api = new ApiProvider(this);
        com.github.crashdemons.playerheads.api.PlayerHeads.setApiInstance(this.api);
    }

    public void onLoad() {
        this.logger = this.getLogger();
        Lang.init(this);
        this.initializeCompatibility();
    }

    public void onEnable() {
        if (this.compatibilityFailed) {
            this.logger.severe(Lang.ERROR_COMPATIBILITY);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configFile = this.getConfig();
        this.configFile.options().copyDefaults(true);
        this.saveDefaultConfig();
        CompatiblePlugins.init(this);
        this.initUpdater();
        this.listener = new PlayerHeadsListener(this);
        PlayerHeadsCommandExecutor commandExecutor = new PlayerHeadsCommandExecutor(this);
        this.listener.registerAll();
        PluginCommand command = this.getCommand("PlayerHeads");
        if (command == null) {
            this.logger.severe(Lang.ERROR_PLUGIN_COMMAND);
        } else {
            command.setExecutor((CommandExecutor)commandExecutor);
        }
        this.logger.info(Lang.COMPATIBILITY_VERSION_CURRENT + Lang.COLON_SPACE + Compatibility.getProvider().getType() + " " + Compatibility.getProvider().getVersion());
    }

    public void onDisable() {
        this.listener.unregisterAll();
        this.logger.info("disabled");
    }

    public void onConfigReloaded() {
        this.listener.reloadConfig();
        CompatiblePlugins.reloadConfig();
    }

    private void initUpdater() {
    }

    public boolean getUpdateReady() {
        return updateReady;
    }

    public String getUpdateName() {
        return updateName;
    }

    static {
        updateReady = false;
        updateName = "";
    }
}

