/*
 * Decompiled with CFR 0.152.
 */
package org.shininet.bukkit.playerheads;

import com.github.crashdemons.playerheads.TexturedSkullType;
import com.github.crashdemons.playerheads.compatibility.RuntimeReferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public final class Config {
    public static final Map<String, configType> configKeys = new HashMap<String, configType>(){
        {
            this.put("pkonly", configType.BOOLEAN);
            this.put("droprate", configType.DOUBLE);
            this.put("lootingrate", configType.DOUBLE);
            this.put("mobpkonly", configType.BOOLEAN);
            for (TexturedSkullType skullType : TexturedSkullType.values()) {
                if (skullType == TexturedSkullType.PLAYER) continue;
                this.put(skullType.getConfigName().toLowerCase(), configType.DOUBLE);
            }
            this.put("fixcase", configType.BOOLEAN);
            this.put("updatecheck", configType.BOOLEAN);
            this.put("broadcast", configType.BOOLEAN);
            this.put("broadcastrange", configType.INT);
            this.put("broadcastmob", configType.BOOLEAN);
            this.put("broadcastmobrange", configType.INT);
            this.put("antideathchest", configType.BOOLEAN);
            this.put("dropboringplayerheads", configType.BOOLEAN);
            this.put("dropvanillaheads", configType.BOOLEAN);
            this.put("convertvanillaheads", configType.BOOLEAN);
            this.put("nerfdeathspam", configType.BOOLEAN);
            this.put("addlore", configType.BOOLEAN);
            this.put("requireitem", configType.BOOLEAN);
            this.put("requireditems", configType.MATERIAL_STRINGLIST);
            this.put("considermobkillers", configType.BOOLEAN);
            this.put("clickspamcount", configType.INT);
            this.put("clickspamthreshold", configType.LONG);
            this.put("deathspamcount", configType.INT);
            this.put("deathspamthreshold", configType.LONG);
            this.put("fixdroppedheads", configType.BOOLEAN);
            this.put("slimemodifier.1", configType.DOUBLE);
            this.put("slimemodifier.2", configType.DOUBLE);
            this.put("slimemodifier.3", configType.DOUBLE);
            this.put("slimemodifier.4", configType.DOUBLE);
            this.put("chargedcreeperbehavior", configType.LOWERCASE_STRING);
            this.put("chargedcreepermodifier", configType.DOUBLE);
            this.put("witherskeletonbehavior", configType.LOWERCASE_STRING);
            this.put("delaywitherdrop", configType.BOOLEAN);
            this.put("delaywitherdropms", configType.INT);
            this.put("ignoredheadnames", configType.UNVALIDATED_STRINGLIST);
            this.put("ignoredheaduuids", configType.UUID_STRINGLIST);
            this.put("pretestblockbreak", configType.BOOLEAN);
            this.put("restoreprofile", configType.BOOLEAN);
            this.put("fixbrokenheads", configType.BOOLEAN);
        }
    };
    public static final String configKeysString = String.join((CharSequence)", ", configKeys.keySet());
    public static final int defaultStackSize = 1;
    public static final String updateSlug = "player-heads";
    public static final int updateID = 46244;
    private static final Predicate<String> validateUUIDString = new Predicate<String>(){

        @Override
        public boolean test(String id) {
            UUID interpretedID;
            try {
                interpretedID = UUID.fromString(id);
            }
            catch (IllegalArgumentException ex) {
                interpretedID = null;
            }
            if (interpretedID == null) {
                System.out.println("Invalid UUID: " + id);
            }
            return interpretedID != null;
        }
    };
    private static final Predicate<String> validateMaterialString = new Predicate<String>(){

        @Override
        public boolean test(String matname) {
            Material mat = RuntimeReferences.getMaterialByName(matname.toUpperCase());
            if (mat != null) {
                return true;
            }
            System.out.println("Unsupported material: " + matname);
            return false;
        }
    };

    private Config() {
    }

    static String getValueDisplayString(FileConfiguration configFile, String key) {
        Object configValue = configFile.get(key);
        String value = "" + configValue;
        if (configValue == null) {
            return "(unset)";
        }
        configType type = configKeys.get(key);
        if (type == null) {
            type = configType.STRING;
        }
        switch (type) {
            case STRING: 
            case LOWERCASE_STRING: {
                return '\"' + value + '\"';
            }
            case DOUBLE: {
                try {
                    double d = configFile.getDouble(key);
                    return value + " (" + d + ")";
                }
                catch (Exception e) {
                    return value + " (?)";
                }
            }
        }
        return value;
    }

    private static boolean getBooleanInputValue(String inputValue) {
        String value = inputValue.toLowerCase();
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equals("1");
    }

    private static List<String> getListInputValue(String inputValue) {
        String[] ids = inputValue.replace('[', ',').replace(']', ',').split("[, ]");
        return new ArrayList<String>(Arrays.asList(ids));
    }

    static void setValue(FileConfiguration configFile, String inputKey, String inputValue) throws NumberFormatException {
        String key = inputKey.toLowerCase();
        configType type = configKeys.get(key);
        if (type == null) {
            type = configType.STRING;
        }
        switch (type) {
            case LOWERCASE_STRING: {
                inputValue = inputValue.toLowerCase();
            }
            case STRING: {
                configFile.set(key, (Object)inputValue);
                break;
            }
            case BOOLEAN: {
                configFile.set(key, (Object)Config.getBooleanInputValue(inputValue));
                break;
            }
            case DOUBLE: {
                configFile.set(key, (Object)Double.parseDouble(inputValue));
                break;
            }
            case INT: {
                configFile.set(key, (Object)Integer.parseInt(inputValue));
                break;
            }
            case LONG: {
                configFile.set(key, (Object)Long.parseLong(inputValue));
                break;
            }
            case UUID_STRINGLIST: {
                List<String> ids = Config.getListInputValue(inputValue);
                ids.removeIf(validateUUIDString.negate());
                configFile.set(key, ids);
                break;
            }
            case UNVALIDATED_STRINGLIST: {
                List<String> elements = Config.getListInputValue(inputValue);
                configFile.set(key, elements);
                break;
            }
            case MATERIAL_STRINGLIST: {
                List<String> materials = Config.getListInputValue(inputValue);
                materials.removeIf(validateMaterialString.negate());
                configFile.set(key, materials);
                break;
            }
            default: {
                throw new IllegalStateException("The specified configuration key has an unsupported data type");
            }
        }
    }

    public static enum configType {
        DOUBLE,
        BOOLEAN,
        INT,
        LONG,
        STRING,
        UNVALIDATED_STRINGLIST,
        UUID_STRINGLIST,
        MATERIAL_STRINGLIST,
        LOWERCASE_STRING;

        @Deprecated
        public static configType LIST;

        static {
            LIST = MATERIAL_STRINGLIST;
        }
    }
}

