/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.plugins.heads;

import com.github.crashdemons.playerheads.compatibility.plugins.heads.HeadModificationHandling;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class ExternalHeads {
    private static final HashMap<String, HeadModificationHandling> nameToHandling = new HashMap();
    private static final HashMap<UUID, HeadModificationHandling> idToHandling = new HashMap();

    private ExternalHeads() {
    }

    public static void loadNamesFromConfig(ConfigurationSection section, String key, HeadModificationHandling handling) {
        nameToHandling.clear();
        List names = section.getStringList(key);
        if (names == null) {
            return;
        }
        for (String name : names) {
            nameToHandling.put(name, handling);
        }
    }

    public static void loadIdsFromConfig(ConfigurationSection section, String key, HeadModificationHandling handling) {
        idToHandling.clear();
        List ids = section.getStringList(key);
        if (ids == null) {
            return;
        }
        for (String id : ids) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(id);
                idToHandling.put(uuid, handling);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Nullable
    public static HeadModificationHandling getHandling(String username) {
        if (username == null) {
            return null;
        }
        return nameToHandling.get(username);
    }

    @Nullable
    public static HeadModificationHandling getHandling(UUID id) {
        if (id == null) {
            return null;
        }
        return idToHandling.get(id);
    }
}

