/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.plugins;

import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.plugins.CompatiblePlugin;
import com.github.crashdemons.playerheads.compatibility.plugins.heads.ExternalHeads;
import com.github.crashdemons.playerheads.compatibility.plugins.heads.HeadModificationHandling;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HeadPluginCompatibility
extends CompatiblePlugin {
    public HeadPluginCompatibility(Plugin parentPlugin) {
        super(parentPlugin, "");
    }

    public HeadPluginCompatibility(Plugin parentPlugin, ConfigurationSection config) {
        super(parentPlugin, "", config);
    }

    @Override
    public void reloadConfig() {
        ExternalHeads.loadNamesFromConfig(this.config, "ignoredheadnames", HeadModificationHandling.NO_INTERACTION);
        ExternalHeads.loadIdsFromConfig(this.config, "ignoredheaduuids", HeadModificationHandling.NO_INTERACTION);
    }

    @NotNull
    public HeadModificationHandling getExternalHeadHandling(String ownerName, UUID ownerID) {
        HeadModificationHandling handling = ExternalHeads.getHandling(ownerName);
        if (handling == null) {
            handling = ExternalHeads.getHandling(ownerID);
        }
        if (handling == null) {
            handling = HeadModificationHandling.NORMAL;
        }
        return handling;
    }

    @NotNull
    public HeadModificationHandling getExternalHeadHandling(BlockState state) {
        if (!(state instanceof Skull)) {
            return HeadModificationHandling.NORMAL;
        }
        String ownerName = Compatibility.getProvider().getOwnerDirect((Skull)state);
        OfflinePlayer owner = Compatibility.getProvider().getOwningPlayerDirect((Skull)state);
        UUID ownerID = null;
        if (owner != null) {
            ownerID = owner.getUniqueId();
        }
        return this.getExternalHeadHandling(ownerName, ownerID);
    }

    @NotNull
    public HeadModificationHandling getExternalHeadHandling(ItemStack stack) {
        if (!stack.hasItemMeta()) {
            return HeadModificationHandling.NORMAL;
        }
        ItemMeta meta = stack.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            return HeadModificationHandling.NORMAL;
        }
        String ownerName = Compatibility.getProvider().getOwnerDirect((SkullMeta)meta);
        OfflinePlayer owner = Compatibility.getProvider().getOwningPlayerDirect((SkullMeta)meta);
        UUID ownerID = null;
        if (owner != null) {
            ownerID = owner.getUniqueId();
        }
        return this.getExternalHeadHandling(ownerName, ownerID);
    }
}

