/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.plugins;

import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public abstract class CompatiblePlugin {
    private String pluginName = "";
    private boolean present = false;
    protected Plugin parentPlugin = null;
    protected ConfigurationSection config = null;

    public CompatiblePlugin(Plugin parentPlugin, String pluginName) {
        this.parentPlugin = parentPlugin;
        this.pluginName = pluginName;
        boolean bl = this.present = this.getPlugin() != null;
        if (!pluginName.isEmpty()) {
            String presence = this.present ? "support" : "not";
            parentPlugin.getLogger().info(pluginName + " " + presence + " detected.");
        }
        this.config = parentPlugin.getConfig();
    }

    public CompatiblePlugin(Plugin parentPlugin, String pluginName, ConfigurationSection config) {
        this(parentPlugin, pluginName);
        this.config = config;
    }

    protected final Plugin getPlugin() {
        if (this.pluginName.isEmpty()) {
            return null;
        }
        return Bukkit.getServer().getPluginManager().getPlugin(this.pluginName);
    }

    public boolean isReady() {
        return true;
    }

    public boolean isPresent() {
        return this.present;
    }

    public String getName() {
        return this.pluginName;
    }

    public void reloadConfig() {
    }

    public Plugin get() {
        if (this.present) {
            return this.getPlugin();
        }
        return null;
    }
}

