/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.legacy;

import com.github.crashdemons.playerheads.compatibility.CompatibilityProvider;
import com.github.crashdemons.playerheads.compatibility.SkullDetails;
import com.github.crashdemons.playerheads.compatibility.SkullType;
import com.github.crashdemons.playerheads.compatibility.Version;
import com.github.crashdemons.playerheads.compatibility.common.Provider_common;
import com.github.crashdemons.playerheads.compatibility.legacy.SkullDetails_legacy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class Provider_legacy
extends Provider_common
implements CompatibilityProvider {
    @Override
    public boolean setOwningPlayer(SkullMeta skullItemMeta, OfflinePlayer op) {
        return skullItemMeta.setOwner(op.getName());
    }

    @Override
    public void setOwningPlayer(Skull skullBlockState, OfflinePlayer op) {
        skullBlockState.setOwner(op.getName());
    }

    @Override
    public ItemStack getItemInMainHand(Player p) {
        return p.getEquipment().getItemInHand();
    }

    @Override
    public ItemStack getItemInMainHand(LivingEntity p) {
        EntityEquipment equipment = p.getEquipment();
        if (equipment == null) {
            return null;
        }
        return equipment.getItemInHand();
    }

    @Override
    public void setItemInMainHand(Player p, ItemStack s) {
        p.getEquipment().setItemInHand(s);
    }

    @Override
    public SkullDetails getSkullDetails(SkullType type) {
        return new SkullDetails_legacy(type);
    }

    @Override
    public boolean getKeepInventory(World world) {
        return Boolean.valueOf(world.getGameRuleValue("keepInventory"));
    }

    @Override
    public SkullType getSkullType(ItemStack s) {
        if (s.getType() != Material.SKULL_ITEM) {
            return null;
        }
        short dmg = s.getDurability();
        try {
            return SkullType.values()[dmg];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public SkullType getSkullType(BlockState s) {
        if (s.getType() != Material.SKULL) {
            return null;
        }
        Skull skullState = (Skull)s;
        return this.adaptSkullType(skullState.getSkullType());
    }

    @Override
    public String getOwner(SkullMeta skull) {
        String owner = null;
        OfflinePlayer op = this.getOwningPlayer(skull);
        if (op != null) {
            owner = op.getName();
        }
        if (owner == null) {
            owner = this.getOwnerDirect(skull);
        }
        return owner;
    }

    @Override
    public String getOwner(Skull skull) {
        String owner = null;
        OfflinePlayer op = this.getOwningPlayer(skull);
        if (op != null) {
            owner = op.getName();
        }
        if (owner == null) {
            owner = this.getOwnerDirect(skull);
        }
        return owner;
    }

    @Override
    public String getCompatibleNameFromEntity(Entity e) {
        if (Version.checkUnder(1, 11)) {
            if (e instanceof Horse) {
                Horse.Variant var = ((Horse)e).getVariant();
                switch (var) {
                    case DONKEY: {
                        return "DONKEY";
                    }
                    case MULE: {
                        return "MULE";
                    }
                    case SKELETON_HORSE: {
                        return "SKELETON_HORSE";
                    }
                    case UNDEAD_HORSE: {
                        return "ZOMBIE_HORSE";
                    }
                }
                return "HORSE";
            }
            if (e instanceof Zombie) {
                if (((Zombie)e).isVillager()) {
                    return "ZOMBIE_VILLAGER";
                }
                if (e.getName().equalsIgnoreCase("HUSK")) {
                    return "HUSK";
                }
            }
            if (e instanceof Skeleton) {
                Skeleton.SkeletonType skeleType = ((Skeleton)e).getSkeletonType();
                if (skeleType == Skeleton.SkeletonType.WITHER) {
                    return "WITHER_SKELETON";
                }
                if (skeleType.name().equalsIgnoreCase("STRAY")) {
                    return "STRAY";
                }
            }
        }
        return super.getCompatibleNameFromEntity(e);
    }

    @Override
    public OfflinePlayer getOfflinePlayerByName(String username) {
        return Bukkit.getOfflinePlayer((String)username);
    }

    protected SkullType adaptSkullType(org.bukkit.SkullType bukkitType) {
        try {
            return SkullType.values()[bukkitType.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    protected org.bukkit.SkullType adaptSkullType(SkullType compatType) {
        if (compatType == SkullType.DRAGON && Version.checkUnder(1, 9)) {
            return org.bukkit.SkullType.PLAYER;
        }
        try {
            return org.bukkit.SkullType.values()[compatType.ordinal()];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public EntityType getEntityTypeFromTypename(String typename) {
        if (this.isZombiePigmanTypename(typename)) {
            return EntityType.PIG_ZOMBIE;
        }
        return super.getEntityTypeFromTypename(typename);
    }
}

