/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.glowstone_1_12;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.github.crashdemons.playerheads.compatibility.CompatibilityProvider;
import com.github.crashdemons.playerheads.compatibility.legacy.Provider_legacy;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Skull;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Provider
extends Provider_legacy
implements CompatibilityProvider {
    @Override
    public String getType() {
        return "glowstone";
    }

    @Override
    public String getVersion() {
        return "1.12";
    }

    private PlayerProfile createProfile(UUID uuid, String textures) {
        PlayerProfile profile = Bukkit.createProfile((UUID)uuid);
        profile.setProperty(new ProfileProperty("textures", textures));
        profile.complete();
        return profile;
    }

    @Override
    public boolean setProfile(ItemMeta headMeta, UUID uuid, String texture) {
        SkullMeta skullMeta = (SkullMeta)headMeta;
        skullMeta.setPlayerProfile(this.createProfile(uuid, texture));
        return true;
    }

    @Override
    public boolean setProfile(Skull headBlockState, UUID uuid, String texture) {
        return false;
    }

    @Override
    public OfflinePlayer getOwningPlayerDirect(SkullMeta skullItemMeta) {
        return skullItemMeta.getOwningPlayer();
    }

    @Override
    public OfflinePlayer getOwningPlayerDirect(Skull skullBlockState) {
        return skullBlockState.getOwningPlayer();
    }

    @Override
    public OfflinePlayer getOwningPlayer(SkullMeta skull) {
        return this.getOwningPlayerDirect(skull);
    }

    @Override
    public OfflinePlayer getOwningPlayer(Skull skull) {
        return this.getOwningPlayerDirect(skull);
    }

    @Override
    public Object getProfile(ItemMeta headMeta) throws IllegalStateException {
        if (headMeta instanceof SkullMeta) {
            SkullMeta skull = (SkullMeta)headMeta;
            return skull.getPlayerProfile();
        }
        return null;
    }

    @Override
    public Object getProfile(Skull headBlockState) throws IllegalStateException {
        throw new IllegalStateException("Retrieving Profiles from BlockStates is not supported in GlowstoneMC/Paper-api-1.12.2");
    }

    @Override
    public boolean setProfile(ItemMeta headMeta, Object profile) throws IllegalStateException, IllegalArgumentException {
        if (!(profile instanceof PlayerProfile)) {
            throw new IllegalArgumentException("Argument passed was not a PlayerProfile");
        }
        if (headMeta instanceof SkullMeta) {
            SkullMeta skull = (SkullMeta)headMeta;
            skull.setPlayerProfile((PlayerProfile)profile);
            return true;
        }
        return false;
    }

    @Override
    public boolean setProfile(Skull headBlockState, Object profile) throws IllegalStateException, IllegalArgumentException {
        if (!(profile instanceof PlayerProfile)) {
            throw new IllegalArgumentException("Argument passed was not a PlayerProfile");
        }
        throw new IllegalStateException("Setting Profiles from BlockStates is not supported in GlowstoneMC/Paper-api-1.12.2");
    }
}

