/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.craftbukkit_1_16;

import com.github.crashdemons.playerheads.compatibility.CompatibilityProvider;
import com.github.crashdemons.playerheads.compatibility.RuntimeReferences;
import com.github.crashdemons.playerheads.compatibility.SkullDetails;
import com.github.crashdemons.playerheads.compatibility.SkullType;
import com.github.crashdemons.playerheads.compatibility.common.Provider_common;
import com.github.crashdemons.playerheads.compatibility.craftbukkit.ProfileUtils;
import com.github.crashdemons.playerheads.compatibility.craftbukkit_1_13.SkullDetails_113;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Provider
extends Provider_common
implements CompatibilityProvider {
    @Override
    public String getType() {
        return "craftbukkit";
    }

    @Override
    public String getVersion() {
        return "1.16";
    }

    @Override
    public OfflinePlayer getOwningPlayerDirect(SkullMeta skullItemMeta) {
        return skullItemMeta.getOwningPlayer();
    }

    @Override
    public OfflinePlayer getOwningPlayerDirect(Skull skullBlockState) {
        return skullBlockState.getOwningPlayer();
    }

    @Override
    public boolean setOwningPlayer(SkullMeta skullItemMeta, OfflinePlayer op) {
        return skullItemMeta.setOwningPlayer(op);
    }

    @Override
    public void setOwningPlayer(Skull skullBlockState, OfflinePlayer op) {
        skullBlockState.setOwningPlayer(op);
    }

    @Override
    public ItemStack getItemInMainHand(LivingEntity p) {
        EntityEquipment equipment = p.getEquipment();
        if (equipment == null) {
            return null;
        }
        return equipment.getItemInMainHand();
    }

    @Override
    public ItemStack getItemInMainHand(Player p) {
        return p.getEquipment().getItemInMainHand();
    }

    @Override
    public void setItemInMainHand(Player p, ItemStack s) {
        p.getEquipment().setItemInMainHand(s);
    }

    @Override
    public SkullDetails getSkullDetails(SkullType type) {
        return new SkullDetails_113(type);
    }

    @Override
    public boolean getKeepInventory(World world) {
        return (Boolean)world.getGameRuleValue(GameRule.KEEP_INVENTORY);
    }

    @Override
    public SkullType getSkullType(ItemStack s) {
        return this.getSkullType(s.getType());
    }

    @Override
    public SkullType getSkullType(BlockState s) {
        return this.getSkullType(s.getType());
    }

    @Override
    public OfflinePlayer getOwningPlayer(SkullMeta skull) {
        OfflinePlayer op = this.getOwningPlayerDirect(skull);
        if (op != null) {
            return op;
        }
        return ProfileUtils.getProfilePlayer(skull);
    }

    @Override
    public OfflinePlayer getOwningPlayer(Skull skull) {
        OfflinePlayer op = this.getOwningPlayerDirect(skull);
        if (op != null) {
            return op;
        }
        return ProfileUtils.getProfilePlayer(skull);
    }

    @Override
    public String getOwner(SkullMeta skull) {
        String owner = null;
        OfflinePlayer op = this.getOwningPlayerDirect(skull);
        if (op == null) {
            op = ProfileUtils.getProfilePlayer(skull);
        }
        if (op != null) {
            owner = op.getName();
        }
        if (owner == null) {
            owner = this.getOwnerDirect(skull);
        }
        return owner;
    }

    @Override
    public String getOwner(Skull skull) {
        String owner = null;
        OfflinePlayer op = this.getOwningPlayerDirect(skull);
        if (op == null) {
            op = ProfileUtils.getProfilePlayer(skull);
        }
        if (op != null) {
            owner = op.getName();
        }
        if (owner == null) {
            owner = this.getOwnerDirect(skull);
        }
        return owner;
    }

    @Override
    public boolean setProfile(ItemMeta headMeta, UUID uuid, String texture) {
        return ProfileUtils.setProfile(headMeta, uuid, texture);
    }

    @Override
    public boolean setProfile(Skull headBlockState, UUID uuid, String texture) {
        return ProfileUtils.setProfile(headBlockState, uuid, texture);
    }

    protected SkullType getSkullType(Material mat) {
        String typeName = mat.name();
        typeName = typeName.replaceFirst("_WALL", "").replaceFirst("_HEAD", "").replaceFirst("_SKULL", "");
        return RuntimeReferences.getSkullTypeByName(typeName);
    }

    @Override
    protected boolean isLegacyCat(Entity e) {
        return false;
    }

    @Override
    public EntityType getEntityTypeFromTypename(String typename) {
        if (this.isZombiePigmanTypename(typename)) {
            return EntityType.ZOMBIFIED_PIGLIN;
        }
        return super.getEntityTypeFromTypename(typename);
    }

    @Override
    public Object getProfile(ItemMeta headMeta) throws IllegalStateException {
        return ProfileUtils.getProfile(headMeta);
    }

    @Override
    public Object getProfile(Skull headBlockState) throws IllegalStateException {
        return ProfileUtils.getProfile(headBlockState);
    }

    @Override
    public boolean setProfile(ItemMeta headMeta, Object profile) throws IllegalArgumentException {
        if (!(profile instanceof GameProfile)) {
            throw new IllegalArgumentException("Passed argument was not a GameProfile object");
        }
        return ProfileUtils.setProfile(headMeta, (GameProfile)profile);
    }

    @Override
    public boolean setProfile(Skull headBlockState, Object profile) throws IllegalArgumentException {
        if (!(profile instanceof GameProfile)) {
            throw new IllegalArgumentException("Passed argument was not a GameProfile object");
        }
        return ProfileUtils.setProfile(headBlockState, (GameProfile)profile);
    }
}

