/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.craftbukkit;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Skull;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

@Deprecated
public class ProfileUtils {
    private static Field getProfileField(Object obj) throws IllegalArgumentException, NoSuchFieldException, SecurityException, IllegalAccessException {
        if (!(obj instanceof SkullMeta) && !(obj instanceof Skull)) {
            throw new IllegalArgumentException("Object is not a supported type: SkullMeta or Skull (blockstate)");
        }
        Field profileField = obj.getClass().getDeclaredField("profile");
        profileField.setAccessible(true);
        return profileField;
    }

    private static GameProfile createProfile(UUID uuid, String texture) {
        GameProfile profile = new GameProfile(uuid, null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        return profile;
    }

    public static GameProfile getProfile(Object obj) throws IllegalStateException {
        try {
            return (GameProfile)ProfileUtils.getProfileField(obj).get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException error) {
            throw new IllegalStateException("The profile field value could not be retrieved");
        }
    }

    public static boolean setProfile(Object obj, GameProfile profile) throws IllegalStateException {
        try {
            ProfileUtils.getProfileField(obj).set(obj, profile);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException error) {
            throw new IllegalStateException("The profile field value could not be retrieved");
        }
    }

    public static boolean setProfile(Object obj, UUID uuid, String texture) throws IllegalStateException {
        return ProfileUtils.setProfile(obj, ProfileUtils.createProfile(uuid, texture));
    }

    public static boolean setProfile(ItemMeta headMeta, UUID uuid, String texture) throws IllegalStateException {
        return ProfileUtils.setProfile((Object)headMeta, uuid, texture);
    }

    public static boolean setProfile(Skull headBlockState, UUID uuid, String texture) throws IllegalStateException {
        return ProfileUtils.setProfile((Object)headBlockState, uuid, texture);
    }

    public static UUID getProfileUUID(SkullMeta headMeta) throws IllegalStateException {
        GameProfile profile = ProfileUtils.getProfile(headMeta);
        if (profile == null) {
            return null;
        }
        return profile.getId();
    }

    public static UUID getProfileUUID(Skull skullBlockState) throws IllegalStateException {
        GameProfile profile = ProfileUtils.getProfile(skullBlockState);
        if (profile == null) {
            return null;
        }
        return profile.getId();
    }

    public static OfflinePlayer getProfilePlayer(SkullMeta headMeta) throws IllegalStateException {
        UUID id = ProfileUtils.getProfileUUID(headMeta);
        if (id == null) {
            return null;
        }
        return Bukkit.getOfflinePlayer((UUID)id);
    }

    public static OfflinePlayer getProfilePlayer(Skull skullBlockState) throws IllegalStateException {
        UUID id = ProfileUtils.getProfileUUID(skullBlockState);
        if (id == null) {
            return null;
        }
        return Bukkit.getOfflinePlayer((UUID)id);
    }
}

