/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility.common;

import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.CompatibilityProvider;
import com.github.crashdemons.playerheads.compatibility.SkullType;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class Provider_common
implements CompatibilityProvider {
    private static final String ETYPE_ZOMBIE_PIGMAN_PRE116 = "PIG_ZOMBIE";
    private static final String ETYPE_ZOMBIE_PIGMAN_POST116 = "ZOMBIFIED_PIGLIN";

    @Override
    public String getOwnerDirect(SkullMeta skullItemMeta) {
        return skullItemMeta.getOwner();
    }

    @Override
    public String getOwnerDirect(Skull skullBlockState) {
        return skullBlockState.getOwner();
    }

    @Override
    public boolean setOwner(SkullMeta skullItemMeta, String owner) {
        return skullItemMeta.setOwner(owner);
    }

    @Override
    public boolean setOwner(Skull skullBlockState, String owner) {
        return skullBlockState.setOwner(owner);
    }

    @Override
    public boolean isHead(ItemStack s) {
        return this.getSkullType(s) != null;
    }

    @Override
    public boolean isHead(BlockState s) {
        return this.getSkullType(s) != null;
    }

    @Override
    public boolean isPlayerhead(ItemStack s) {
        return this.getSkullType(s) == SkullType.PLAYER;
    }

    @Override
    public boolean isPlayerhead(BlockState s) {
        return this.getSkullType(s) == SkullType.PLAYER;
    }

    @Override
    public boolean isMobhead(ItemStack s) {
        SkullType t = this.getSkullType(s);
        return t != null && t != SkullType.PLAYER;
    }

    @Override
    public boolean isMobhead(BlockState s) {
        SkullType t = this.getSkullType(s);
        return t != null && t != SkullType.PLAYER;
    }

    @Override
    public String getCompatibleNameFromEntity(Entity e) {
        if (this.isZombiePigman(e)) {
            return ETYPE_ZOMBIE_PIGMAN_POST116;
        }
        if (this.isLegacyCat(e)) {
            return "CAT";
        }
        return e.getType().name().toUpperCase();
    }

    @Override
    public OfflinePlayer getOfflinePlayerByName(String username) {
        return Bukkit.getOfflinePlayer((String)username);
    }

    @Override
    public EntityType getEntityTypeFromTypename(String typename) {
        try {
            return EntityType.valueOf((String)typename.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isZombiePigmanTypename(String typename) {
        return (typename = typename.toUpperCase()) != null && (typename.equals(ETYPE_ZOMBIE_PIGMAN_PRE116) || typename.equals(ETYPE_ZOMBIE_PIGMAN_POST116));
    }

    protected boolean isZombiePigman(Entity e) {
        return e instanceof PigZombie;
    }

    protected boolean isLegacyCat(Entity e) {
        if (e instanceof Ocelot && e instanceof Tameable) {
            return ((Tameable)e).isTamed();
        }
        return false;
    }

    @Override
    public Optional<Object> getOptionalProfile(ItemMeta skullMeta) {
        try {
            return Optional.of(Compatibility.getProvider().getProfile(skullMeta));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Object> getOptionalProfile(Skull skullState) {
        try {
            return Optional.of(Compatibility.getProvider().getProfile(skullState));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean setOptionalProfile(Skull skullState, Optional<Object> profile) {
        if (!profile.isPresent()) {
            return false;
        }
        try {
            return Compatibility.getProvider().setProfile(skullState, profile.get());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setOptionalProfile(ItemMeta skullMeta, Optional<Object> profile) {
        if (!profile.isPresent()) {
            return false;
        }
        try {
            return Compatibility.getProvider().setProfile(skullMeta, profile.get());
        }
        catch (Exception e) {
            return false;
        }
    }
}

