/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility;

import com.github.crashdemons.playerheads.compatibility.RuntimeReferences;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityUnsupportedException;
import com.github.crashdemons.playerheads.compatibility.exceptions.UnknownVersionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class Version {
    private static String serverType = "";
    private static int versionMajor = 0;
    private static int versionMinor = 0;
    private static boolean isInit = false;
    private static final String[][] serverTypeByClass = new String[][]{{"com.github.crashdemons.playerheads.compatibility.faketestserver_1_0.Provider", "faketestserver"}, {"net.glowstone.GlowServer", "glowstone"}, {"org.github.paperspigot.PaperSpigotConfig", "paper"}, {"com.destroystokyo.paper.PaperConfig", "paper"}, {"org.spigotmc.SpigotConfig", "spigot"}, {"org.bukkit.craftbukkit.Main", "craftbukkit"}};

    private Version() {
    }

    public static boolean checkAtLeast(int major, int minor) {
        Version.init();
        return versionMajor > major || versionMajor == major && versionMinor >= minor;
    }

    public static boolean checkUnder(int major, int minor) {
        Version.init();
        return versionMajor < major || versionMajor == major && versionMinor < minor;
    }

    public static boolean checkEquals(int major, int minor) {
        Version.init();
        return versionMajor == major && versionMinor == minor;
    }

    public static String getRawServerVersion() {
        return Bukkit.getVersion();
    }

    public static String getBukkitClassVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String getString() {
        return versionMajor + "." + versionMinor;
    }

    public static String getType() {
        return serverType;
    }

    public static synchronized void init() throws UnknownVersionException, CompatibilityUnsupportedException {
        if (isInit) {
            return;
        }
        int[] mcver = Version.getMCVersionParts();
        if (mcver == null) {
            throw new UnknownVersionException("The current Bukkit build did not supply a version string that could be understood.");
        }
        versionMajor = mcver[0];
        versionMinor = mcver[1];
        serverType = Version.getServerType();
        isInit = true;
    }

    private static String getBukkitVersion() {
        String rawVersion = Version.getBukkitClassVersion();
        String versionRegex = ".*v([0-9_]+).*?";
        Pattern pattern = Pattern.compile(versionRegex);
        Matcher matcher = pattern.matcher(rawVersion);
        if (matcher.matches()) {
            String versionString = matcher.group(1);
            if ((versionString = versionString.replace('_', '.')).endsWith(".")) {
                versionString = versionString.substring(0, versionString.length() - 1);
            }
            return versionString;
        }
        return "";
    }

    private static String getMCVersion() {
        String rawVersion = Version.getRawServerVersion();
        String versionRegex = ".*\\(MC: ([0-9.]+).*?";
        Pattern pattern = Pattern.compile(versionRegex);
        Matcher matcher = pattern.matcher(rawVersion);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private static String getInternalVersion() {
        String version = Version.getMCVersion();
        if (version.isEmpty()) {
            version = Version.getBukkitVersion();
        }
        return version;
    }

    private static int[] getMCVersionParts() {
        String ver = Version.getInternalVersion();
        if (ver.isEmpty()) {
            return null;
        }
        String[] parts = (ver + ".0.0").split("\\.");
        try {
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String getServerType() {
        for (int i = 0; i < serverTypeByClass.length; ++i) {
            if (!RuntimeReferences.hasClass(serverTypeByClass[i][0])) continue;
            return serverTypeByClass[i][1];
        }
        return "unknown";
    }
}

