/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility;

import com.github.crashdemons.playerheads.compatibility.CompatibleSkullMaterial;
import com.github.crashdemons.playerheads.compatibility.SkullType;
import java.lang.reflect.Method;
import org.bukkit.Material;

public final class RuntimeReferences {
    private RuntimeReferences() {
    }

    public static CompatibleSkullMaterial getCompatibleMaterialByName(String name) {
        try {
            return CompatibleSkullMaterial.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Material getMaterialByName(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static SkullType getSkullTypeByName(String name) {
        try {
            return SkullType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Class<?> getClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> classobj, String methodname, Class<?> ... parameterTypes) {
        try {
            return classobj.getMethod(methodname, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getMethod(String classname, String methodname, Class<?> ... parameterTypes) {
        Class<?> classobj = RuntimeReferences.getClass(classname);
        if (classobj == null) {
            return null;
        }
        return RuntimeReferences.getMethod(classobj, methodname, parameterTypes);
    }

    public static boolean hasClass(String classname) {
        try {
            Class<?> providerClass = Class.forName(classname);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

