/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility;

import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.RuntimeReferences;
import com.github.crashdemons.playerheads.compatibility.SkullDetails;
import com.github.crashdemons.playerheads.compatibility.SkullType;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

public enum CompatibleSkullMaterial {
    SKELETON(SkullType.SKELETON),
    WITHER_SKELETON(SkullType.WITHER_SKELETON),
    ZOMBIE(SkullType.ZOMBIE),
    PLAYER(SkullType.PLAYER),
    CREEPER(SkullType.CREEPER),
    ENDER_DRAGON(SkullType.DRAGON);

    private final SkullType skullType;
    private SkullDetails cachedDetails = null;

    private CompatibleSkullMaterial(SkullType type) {
        this.skullType = type;
    }

    public SkullDetails getDetails() {
        if (this.cachedDetails == null) {
            this.cachedDetails = Compatibility.getProvider().getSkullDetails(this.skullType);
        }
        return this.cachedDetails;
    }

    public boolean isSupported() {
        return this == PLAYER || !this.getDetails().isBackedByPlayerhead();
    }

    public static CompatibleSkullMaterial get(SkullType type) {
        if (type == null) {
            return null;
        }
        if (type == SkullType.DRAGON) {
            return ENDER_DRAGON;
        }
        if (type == SkullType.WITHER_SKELETON) {
            return WITHER_SKELETON;
        }
        return RuntimeReferences.getCompatibleMaterialByName(type.name());
    }

    public static CompatibleSkullMaterial get(ItemStack stack) {
        return CompatibleSkullMaterial.get(Compatibility.getProvider().getSkullType(stack));
    }

    public static CompatibleSkullMaterial get(BlockState state) {
        return CompatibleSkullMaterial.get(Compatibility.getProvider().getSkullType(state));
    }
}

