/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility;

import com.github.crashdemons.playerheads.compatibility.plugins.HeadPluginCompatibility;
import com.github.crashdemons.playerheads.compatibility.plugins.NoCheatPlusCompatibility;
import com.github.crashdemons.playerheads.compatibility.plugins.ProtectionPluginCompatibility;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class CompatiblePlugins {
    public static NoCheatPlusCompatibility nocheatplus = null;
    public static ProtectionPluginCompatibility protection = null;
    public static HeadPluginCompatibility heads = null;
    private static boolean ready = false;
    private static Plugin parentPlugin = null;

    private CompatiblePlugins() {
    }

    public static void init(Plugin parentPluginInstance) {
        parentPlugin = parentPluginInstance;
        nocheatplus = new NoCheatPlusCompatibility(parentPluginInstance);
        protection = new ProtectionPluginCompatibility(parentPluginInstance);
        heads = new HeadPluginCompatibility(parentPluginInstance);
        CompatiblePlugins.reloadConfig();
        ready = true;
    }

    public static void init(Plugin parentPluginInstance, ConfigurationSection config) {
        parentPlugin = parentPluginInstance;
        nocheatplus = new NoCheatPlusCompatibility(parentPluginInstance);
        protection = new ProtectionPluginCompatibility(parentPluginInstance);
        heads = new HeadPluginCompatibility(parentPluginInstance, config);
        CompatiblePlugins.reloadConfig();
        ready = true;
    }

    public static void reloadConfig() {
        nocheatplus.reloadConfig();
        protection.reloadConfig();
        heads.reloadConfig();
    }

    public static boolean testBlockBreak(Block block, Player player) {
        boolean isNotExempt = false;
        if (nocheatplus.isPresent()) {
            boolean bl = isNotExempt = !nocheatplus.isExemptFastbreak(player);
            if (isNotExempt) {
                nocheatplus.exemptFastbreak(player);
            }
        }
        boolean blockBreakSucceeded = protection.testBlockBreak(block, player);
        if (nocheatplus.isPresent() && isNotExempt) {
            nocheatplus.unexemptFastbreak(player);
        }
        return blockBreakSucceeded;
    }

    public static boolean isReady() {
        return ready;
    }
}

