/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.compatibility;

import com.github.crashdemons.playerheads.compatibility.CompatibilityProvider;
import com.github.crashdemons.playerheads.compatibility.CompatibilitySupport;
import com.github.crashdemons.playerheads.compatibility.Version;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityConflictException;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityMisconfiguredException;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityUnavailableException;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityUnregisteredException;
import com.github.crashdemons.playerheads.compatibility.exceptions.CompatibilityUnsupportedException;
import com.github.crashdemons.playerheads.compatibility.exceptions.UnknownVersionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class Compatibility {
    private static CompatibilityProvider provider = null;
    private static final String FALLBACK_PROVIDER_TYPE = "craftbukkit";
    private static Integer[] recommendedVersion = null;
    private static String recommendedType = "";
    private static final int REQUIRED_VERSION_MAJOR = 1;
    private static final int REQUIRED_VERSION_MINOR = 8;

    private Compatibility() {
    }

    public static synchronized boolean init() throws UnknownVersionException, CompatibilityUnsupportedException, CompatibilityUnavailableException, CompatibilityConflictException {
        Version.init();
        if (Version.checkUnder(1, 8)) {
            throw new CompatibilityUnsupportedException("Server versions under 1.8 are not supported.");
        }
        if (!CompatibilitySupport.isFinalized()) {
            throw new CompatibilityMisconfiguredException("This project has been misconfigured - compatibility support was not present.");
        }
        boolean isUsingFallback = false;
        CompatibilityProvider bestprovider = Compatibility.loadRecommendedProvider();
        if (bestprovider == null) {
            isUsingFallback = true;
            bestprovider = Compatibility.loadFallbackProvider(recommendedType);
        }
        if (bestprovider == null && !recommendedType.equals(FALLBACK_PROVIDER_TYPE)) {
            bestprovider = Compatibility.loadFallbackProvider(FALLBACK_PROVIDER_TYPE);
        }
        if (bestprovider == null) {
            throw new CompatibilityUnavailableException("No suitable compatibility provider could be found.");
        }
        Compatibility.registerProvider(bestprovider);
        return !isUsingFallback;
    }

    public static boolean isProviderAvailable() {
        return provider != null;
    }

    public static void registerProvider(CompatibilityProvider obj) throws CompatibilityConflictException {
        if (provider != null) {
            throw new CompatibilityConflictException("Multiple compatibility-providers were registered - only one is supported at a time.");
        }
        provider = obj;
    }

    @Deprecated
    public static boolean unregisterProvider() {
        if (provider == null) {
            return false;
        }
        provider = null;
        return true;
    }

    public static CompatibilityProvider getProvider() throws CompatibilityUnregisteredException {
        if (provider == null) {
            throw new CompatibilityUnregisteredException("Requested compatibility provider before any were registered - Compatibility.init must run first.");
        }
        return provider;
    }

    public static String getRecommendedProviderType() {
        return recommendedType;
    }

    public static String getRecommendedProviderVersion() {
        if (recommendedVersion == null) {
            return "";
        }
        return recommendedVersion[0] + "." + recommendedVersion[1];
    }

    private static String determineRecommendedType() {
        String nativeType = Version.getType();
        if (CompatibilitySupport.VERSIONS.keySet().contains(nativeType)) {
            return nativeType;
        }
        switch (nativeType) {
            default: 
        }
        return FALLBACK_PROVIDER_TYPE;
    }

    private static CompatibilityProvider loadRecommendedProvider() {
        recommendedType = Compatibility.determineRecommendedType();
        Integer[][] supportedVersions = CompatibilitySupport.VERSIONS.get(recommendedType);
        if (supportedVersions == null) {
            return null;
        }
        for (int i = 0; i < supportedVersions.length; ++i) {
            Integer[] ver = supportedVersions[i];
            if (!Version.checkAtLeast(ver[0], ver[1])) continue;
            recommendedVersion = ver;
            try {
                return Compatibility.loadProviderByVersion(recommendedType, ver[0], ver[1]);
            }
            catch (CompatibilityUnavailableException e) {
                return null;
            }
        }
        return null;
    }

    private static CompatibilityProvider loadFallbackProvider(String type) {
        Integer[][] supportedVersions = CompatibilitySupport.VERSIONS.get(type);
        if (supportedVersions == null) {
            return null;
        }
        for (int i = 0; i < supportedVersions.length; ++i) {
            Integer[] ver = supportedVersions[i];
            if (!Version.checkAtLeast(ver[0], ver[1])) continue;
            try {
                return Compatibility.loadProviderByVersion(type, ver[0], ver[1]);
            }
            catch (CompatibilityUnavailableException compatibilityUnavailableException) {
                // empty catch block
            }
        }
        return null;
    }

    private static CompatibilityProvider loadProviderByVersion(String type, int major, int minor) throws CompatibilityUnavailableException {
        System.out.println("Trying provider: " + type + "_" + major + "_" + minor);
        String pkg = Compatibility.class.getPackage().getName();
        String classname = pkg + "." + type + "_" + major + "_" + minor + ".Provider";
        try {
            Class<?> providerClass = Class.forName(classname);
            Constructor<?> ctor = providerClass.getConstructor(new Class[0]);
            Object potentialProvider = ctor.newInstance(new Object[0]);
            return (CompatibilityProvider)potentialProvider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CompatibilityUnavailableException("Missing compatibility provider: " + classname, e);
        }
    }
}

