/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.api;

import com.github.crashdemons.playerheads.SkullConverter;
import com.github.crashdemons.playerheads.SkullManager;
import com.github.crashdemons.playerheads.TexturedSkullType;
import com.github.crashdemons.playerheads.api.HeadType;
import com.github.crashdemons.playerheads.api.PlayerHeadsAPI;
import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.CompatibilityProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.shininet.bukkit.playerheads.PlayerHeads;
import org.shininet.bukkit.playerheads.PlayerHeadsPlugin;

public class ApiProvider
implements PlayerHeadsAPI {
    private final PlayerHeads plugin;

    public ApiProvider(PlayerHeadsPlugin plugin) {
        this.plugin = (PlayerHeads)plugin;
    }

    @Override
    public PlayerHeadsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public HeadType getHeadFrom(ItemStack s) {
        return SkullConverter.skullTypeFromItemStack(s);
    }

    @Override
    public HeadType getHeadFrom(BlockState s) {
        return SkullConverter.skullTypeFromBlockState(s);
    }

    @Override
    public HeadType getHeadOf(Entity e) {
        return SkullConverter.skullTypeFromEntity(e);
    }

    @Override
    @Deprecated
    public HeadType getHeadOf(EntityType t) {
        try {
            return TexturedSkullType.valueOf(t.name());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ItemStack getHeadItem(HeadType h, int num) {
        TexturedSkullType type = this.headFromApiHead(h);
        if (type == null) {
            return null;
        }
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        boolean usevanillaskull = this.plugin.configFile.getBoolean("dropvanillaheads");
        if (type == TexturedSkullType.PLAYER) {
            return SkullManager.PlayerSkull(num, true);
        }
        return SkullManager.MobSkull(type, num, usevanillaskull, addLore, null);
    }

    @Override
    public ItemStack getHeadDrop(Entity e) {
        ItemStack drop;
        TexturedSkullType type = SkullConverter.skullTypeFromEntity(e);
        if (type == null) {
            return null;
        }
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        if (e instanceof Player) {
            Player player = (Player)e;
            String skullOwner = this.plugin.configFile.getBoolean("dropboringplayerheads") ? "" : player.getName();
            drop = skullOwner == null || skullOwner.isEmpty() ? SkullManager.PlayerSkull(addLore) : SkullManager.PlayerSkull(skullOwner, addLore);
        } else {
            boolean usevanillaskull = this.plugin.configFile.getBoolean("dropvanillaheads");
            drop = SkullManager.MobSkull(type, usevanillaskull, addLore, null);
        }
        return drop;
    }

    private TexturedSkullType headFromApiHead(HeadType h) {
        return TexturedSkullType.get(h.getOwner());
    }

    @Override
    public ItemStack getBoringPlayerheadItem(int num) {
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        return SkullManager.PlayerSkull(num, addLore);
    }

    @Override
    public ItemStack getHeadItem(String username, int num, boolean forceOwner) {
        if (!forceOwner && this.plugin.configFile.getBoolean("dropboringplayerheads")) {
            return this.getBoringPlayerheadItem(num);
        }
        boolean addLore = this.plugin.configFile.getBoolean("addlore");
        return SkullManager.PlayerSkull(username, num, addLore, null);
    }

    @Override
    public ItemStack getHeadItem(OfflinePlayer player, int num, boolean forceOwner) {
        String name = player.getName();
        if (name == null) {
            return null;
        }
        return this.getHeadItem(name, num, forceOwner);
    }

    @Override
    public CompatibilityProvider getCompatibilityProvider() {
        if (!Compatibility.isProviderAvailable()) {
            return null;
        }
        return Compatibility.getProvider();
    }
}

