/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.antispam;

import com.github.crashdemons.playerheads.antispam.EventSpamPreventer;
import com.github.crashdemons.playerheads.antispam.EventSpamRecord;
import com.github.crashdemons.playerheads.antispam.SpamResult;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;

public class PlayerDeathSpamPreventer
extends EventSpamPreventer {
    private final long deathThresholdMs;

    public PlayerDeathSpamPreventer(int numRecords, long timeMS) {
        super(numRecords);
        this.deathThresholdMs = timeMS;
    }

    @Override
    public SpamResult recordEvent(Event event) {
        if (event instanceof EntityDeathEvent) {
            return this.recordEvent((EntityDeathEvent)event);
        }
        return new SpamResult(false);
    }

    public synchronized SpamResult recordEvent(EntityDeathEvent event) {
        SpamResult result = new SpamResult(false);
        PlayerDeathRecord record = new PlayerDeathRecord(event);
        for (EventSpamRecord otherRecordObj : this.records) {
            PlayerDeathRecord otherRecord = (PlayerDeathRecord)otherRecordObj;
            if (!record.closeTo(otherRecord)) continue;
            result.toggle();
            break;
        }
        this.addRecord(record);
        return result;
    }

    private class PlayerDeathRecord
    extends EventSpamRecord {
        private UUID victimId;
        private UUID killerId;

        public PlayerDeathRecord(EntityDeathEvent event) {
            super((Event)event);
            this.victimId = null;
            this.killerId = null;
            LivingEntity victimEntity = event.getEntity();
            if (victimEntity instanceof Player) {
                Player victim = (Player)victimEntity;
                this.victimId = victim.getUniqueId();
                if (this.victimId != null) {
                    Player killer = victim.getKiller();
                    this.killerId = killer == null ? null : killer.getUniqueId();
                }
            }
        }

        boolean sameKiller(PlayerDeathRecord record) {
            if (record == null) {
                return false;
            }
            if (this.killerId == null && record.killerId == null) {
                return true;
            }
            if (this.killerId == null || record.killerId == null) {
                return false;
            }
            return this.killerId.equals(record.killerId);
        }

        boolean closeTo(PlayerDeathRecord record) {
            if (record == null) {
                return false;
            }
            if (this.victimId == null) {
                return false;
            }
            if (this.victimId.equals(record.victimId) && this.sameKiller(record)) {
                return super.closeTo(record, PlayerDeathSpamPreventer.this.deathThresholdMs);
            }
            return false;
        }
    }
}

