/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads.antispam;

import com.github.crashdemons.playerheads.antispam.EventSpamPreventer;
import com.github.crashdemons.playerheads.antispam.EventSpamRecord;
import com.github.crashdemons.playerheads.antispam.SpamResult;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;

public class InteractSpamPreventer
extends EventSpamPreventer {
    private final long interactThresholdMs;

    public InteractSpamPreventer(int numRecords, long timeMS) {
        super(numRecords);
        this.interactThresholdMs = timeMS;
    }

    @Override
    public SpamResult recordEvent(Event event) {
        if (event instanceof PlayerInteractEvent) {
            return this.recordEvent((PlayerInteractEvent)event);
        }
        return new SpamResult(false);
    }

    public synchronized SpamResult recordEvent(PlayerInteractEvent event) {
        SpamResult result = new SpamResult(false);
        InteractRecord record = new InteractRecord(event);
        for (EventSpamRecord otherRecordObj : this.records) {
            InteractRecord otherRecord = (InteractRecord)otherRecordObj;
            if (!record.closeTo(otherRecord)) continue;
            result.toggle();
            break;
        }
        this.addRecord(record);
        return result;
    }

    private final class InteractRecord
    extends EventSpamRecord {
        final Location location;
        final UUID playerId;

        public InteractRecord(PlayerInteractEvent event) {
            super((Event)event);
            this.playerId = event.getPlayer().getUniqueId();
            Block block = event.getClickedBlock();
            this.location = block != null ? block.getLocation() : null;
        }

        boolean closeTo(InteractRecord record) {
            if (record == null) {
                return false;
            }
            if (record.playerId.equals(this.playerId)) {
                if (record.location == null || this.location == null) {
                    return false;
                }
                if (record.location.equals((Object)this.location) && super.closeTo(record, InteractSpamPreventer.this.interactThresholdMs)) {
                    return true;
                }
            }
            return false;
        }
    }
}

