/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads;

import com.github.crashdemons.playerheads.TexturedSkullType;
import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.CompatibleSkullMaterial;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.shininet.bukkit.playerheads.Lang;

public final class SkullManager {
    private SkullManager() {
    }

    private static void applyLore(SkullMeta headMeta, String extra) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(" ");
        if (!Lang.LORE_PLUGIN_NAME.isEmpty()) {
            lore.add(ChatColor.BLUE + "" + ChatColor.ITALIC + Lang.LORE_PLUGIN_NAME);
        }
        if (!extra.isEmpty()) {
            lore.add(extra);
        }
        headMeta.setLore(lore);
    }

    private static void applyOwningPlayer(SkullMeta headMeta, OfflinePlayer owner) {
        Compatibility.getProvider().setOwningPlayer(headMeta, owner);
    }

    private static void applyDisplayName(SkullMeta headMeta, String display) {
        headMeta.setDisplayName(display);
    }

    private static boolean applyTexture(SkullMeta headMeta, UUID uuid, String texture) {
        return Compatibility.getProvider().setProfile((ItemMeta)headMeta, uuid, texture);
    }

    public static ItemStack MobSkull(TexturedSkullType type, boolean useVanillaHeads, boolean addLore, Optional<Object> profile) {
        return SkullManager.MobSkull(type, 1, useVanillaHeads, addLore, profile);
    }

    public static ItemStack MobSkull(TexturedSkullType type, int quantity, boolean useVanillaHeads, boolean addLore, Optional<Object> profile) {
        CompatibleSkullMaterial mat = type.getCompatibleMaterial();
        if (type.hasDedicatedItem()) {
            if (useVanillaHeads) {
                return mat.getDetails().createItemStack(quantity);
            }
            mat = CompatibleSkullMaterial.PLAYER;
        }
        ItemStack stack = mat.getDetails().createItemStack(quantity);
        SkullMeta headMeta = (SkullMeta)stack.getItemMeta();
        SkullManager.applyTexture(headMeta, type.getOwner(), type.getTexture());
        SkullManager.applyDisplayName(headMeta, ChatColor.RESET + "" + ChatColor.YELLOW + type.getDisplayName());
        if (addLore) {
            SkullManager.applyLore(headMeta, ChatColor.GREEN + Lang.LORE_HEAD_MOB);
        }
        if (profile != null) {
            Compatibility.getProvider().setOptionalProfile((ItemMeta)headMeta, profile);
        }
        stack.setItemMeta((ItemMeta)headMeta);
        return stack;
    }

    private static ItemStack PlayerSkull(OfflinePlayer owner, boolean addLore) {
        return SkullManager.PlayerSkull(owner, 1, addLore, null);
    }

    private static ItemStack PlayerSkull(OfflinePlayer owner, int quantity, boolean addLore, Optional<Object> profile) {
        ItemStack stack = CompatibleSkullMaterial.PLAYER.getDetails().createItemStack(quantity);
        SkullMeta headMeta = (SkullMeta)stack.getItemMeta();
        String name = null;
        if (owner != null) {
            SkullManager.applyOwningPlayer(headMeta, owner);
            name = owner.getName();
        }
        if (name == null) {
            name = "Player";
        }
        SkullManager.applyDisplayName(headMeta, ChatColor.RESET + "" + ChatColor.YELLOW + TexturedSkullType.getDisplayName(name));
        if (addLore) {
            SkullManager.applyLore(headMeta, ChatColor.RED + Lang.LORE_HEAD_PLAYER);
        }
        if (profile != null) {
            Compatibility.getProvider().setOptionalProfile((ItemMeta)headMeta, profile);
        }
        stack.setItemMeta((ItemMeta)headMeta);
        return stack;
    }

    public static ItemStack PlayerSkull(boolean addLore) {
        return SkullManager.PlayerSkull(1, addLore);
    }

    public static ItemStack PlayerSkull(int quantity, boolean addLore) {
        return SkullManager.PlayerSkull((OfflinePlayer)null, quantity, addLore, null);
    }

    public static ItemStack PlayerSkull(String owner, boolean addLore) {
        return SkullManager.PlayerSkull(owner, 1, addLore, null);
    }

    public static ItemStack PlayerSkull(String owner, int quantity, boolean addLore, Optional<Object> profile) {
        if (owner == null || owner.isEmpty()) {
            throw new IllegalArgumentException("Creating a playerhead with a null or empty username is not possible with this method.");
        }
        OfflinePlayer op = Compatibility.getProvider().getOfflinePlayerByName(owner);
        return SkullManager.PlayerSkull(op, quantity, addLore, profile);
    }

    public static ItemStack spawnSkull(String spawnString, boolean usevanillaheads, boolean addLore) {
        return SkullManager.spawnSkull(spawnString, 1, usevanillaheads, addLore);
    }

    public static ItemStack spawnSkull(String spawnString, int quantity, boolean usevanillaheads, boolean addLore) {
        TexturedSkullType type = spawnString.isEmpty() ? TexturedSkullType.PLAYER : TexturedSkullType.getBySpawnName(spawnString);
        if (type == null) {
            return SkullManager.PlayerSkull(spawnString, quantity, addLore, null);
        }
        return SkullManager.MobSkull(type, quantity, usevanillaheads, addLore, null);
    }

    public static void updatePlayerSkullState(BlockState skullState) {
        skullState.update();
    }
}

