/*
 * Decompiled with CFR 0.152.
 */
package com.github.crashdemons.playerheads;

import com.github.crashdemons.playerheads.TexturedSkullType;
import com.github.crashdemons.playerheads.compatibility.Compatibility;
import com.github.crashdemons.playerheads.compatibility.CompatibleSkullMaterial;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public final class SkullConverter {
    private SkullConverter() {
    }

    public static TexturedSkullType skullTypeFromEntity(Entity entity) {
        String entityName = Compatibility.getProvider().getCompatibleNameFromEntity(entity);
        try {
            return TexturedSkullType.valueOf(entityName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Deprecated
    public static OfflinePlayer getSkullOwningPlayer(SkullMeta skullMeta) {
        return Compatibility.getProvider().getOwningPlayer(skullMeta);
    }

    @Deprecated
    public static OfflinePlayer getSkullOwningPlayer(Skull skullBlockState) {
        return Compatibility.getProvider().getOwningPlayer(skullBlockState);
    }

    @Deprecated
    public static String getSkullOwner(SkullMeta skullMeta) {
        return Compatibility.getProvider().getOwner(skullMeta);
    }

    @Deprecated
    public static String getSkullOwner(Skull skullBlockState) {
        return Compatibility.getProvider().getOwner(skullBlockState);
    }

    public static TexturedSkullType skullTypeFromItemStack(ItemStack stack) {
        CompatibleSkullMaterial mat = CompatibleSkullMaterial.get(stack);
        if (mat == null) {
            return null;
        }
        if (!mat.getDetails().isBackedByPlayerhead()) {
            return TexturedSkullType.get(mat);
        }
        SkullMeta skullState = (SkullMeta)stack.getItemMeta();
        OfflinePlayer op = Compatibility.getProvider().getOwningPlayer(skullState);
        if (op == null) {
            return TexturedSkullType.PLAYER;
        }
        UUID owner = op.getUniqueId();
        if (owner == null) {
            return TexturedSkullType.PLAYER;
        }
        TexturedSkullType match = TexturedSkullType.get(owner);
        if (match == null) {
            return TexturedSkullType.PLAYER;
        }
        return match;
    }

    public static TexturedSkullType skullTypeFromBlockState(BlockState state) {
        CompatibleSkullMaterial mat = CompatibleSkullMaterial.get(state);
        if (mat == null) {
            return null;
        }
        if (!mat.getDetails().isBackedByPlayerhead()) {
            return TexturedSkullType.get(mat);
        }
        Skull skullState = (Skull)state;
        OfflinePlayer op = Compatibility.getProvider().getOwningPlayer(skullState);
        if (op == null) {
            return TexturedSkullType.PLAYER;
        }
        UUID owner = op.getUniqueId();
        if (owner == null) {
            return TexturedSkullType.PLAYER;
        }
        TexturedSkullType match = TexturedSkullType.get(owner);
        if (match == null) {
            return TexturedSkullType.PLAYER;
        }
        return match;
    }

    public static EntityType entityTypeFromSkullType(TexturedSkullType skullType) {
        String skullName = skullType.name().toUpperCase();
        return Compatibility.getProvider().getEntityTypeFromTypename(skullName);
    }
}

